"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemovableItem = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _use_cases_context = require("../cases_context/use_cases_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RemovableItemComponent = ({
  children,
  tooltipContent,
  buttonAriaLabel,
  onRemoveItem,
  dataTestSubjPrefix = ''
}) => {
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const [isHovering, setIsHovering] = (0, _react.useState)(false);
  const onFocus = () => setIsHovering(true);
  const onFocusLeave = () => setIsHovering(false);
  const dataTestSubj = dataTestSubjPrefix.length > 0 ? `${dataTestSubjPrefix}-remove-` : 'remove-';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    justifyContent: "spaceBetween",
    onMouseEnter: onFocus,
    onMouseLeave: onFocusLeave,
    "data-test-subj": `${dataTestSubj}group`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, children), permissions.update && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "left",
    content: tooltipContent,
    "data-test-subj": `${dataTestSubj}tooltip`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    css: {
      opacity: isHovering ? 1 : 0
    },
    onFocus: onFocus,
    onBlur: onFocusLeave,
    "data-test-subj": `${dataTestSubj}button`,
    "aria-label": buttonAriaLabel,
    iconType: "cross",
    color: "danger",
    iconSize: "m",
    onClick: onRemoveItem
  }))));
};
RemovableItemComponent.displayName = 'RemovableItem';
const RemovableItem = exports.RemovableItem = /*#__PURE__*/_react.default.memo(RemovableItemComponent);