"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getContentWrapperCss = exports.ScrollableMarkdown = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _renderer = require("./renderer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getContentWrapperCss = euiTheme => (0, _react2.css)`
  padding: ${`${euiTheme.size.m} ${euiTheme.size.l}`};
  text-overflow: ellipsis;
  word-break: break-word;
  display: -webkit-box;
  -webkit-box-orient: vertical;
`;
exports.getContentWrapperCss = getContentWrapperCss;
const ScrollableMarkdownRenderer = ({
  content
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement("div", {
    className: 'eui-xScroll',
    css: getContentWrapperCss(euiTheme),
    "data-test-subj": "scrollable-markdown"
  }, /*#__PURE__*/_react.default.createElement(_renderer.MarkdownRenderer, null, content));
};
ScrollableMarkdownRenderer.displayName = 'ScrollableMarkdownRenderer';
const ScrollableMarkdown = exports.ScrollableMarkdown = /*#__PURE__*/_react.default.memo(ScrollableMarkdownRenderer);