"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomFieldFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _form = require("./form");
var _domain = require("../../../common/types/domain");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CustomFieldFlyoutComponent = ({
  onCloseFlyout,
  onSaveField,
  isLoading,
  disabled,
  customField
}) => {
  const dataTestSubj = 'custom-field-flyout';
  const [formState, setFormState] = (0, _react.useState)({
    isValid: undefined,
    submit: async () => ({
      isValid: false,
      data: {
        key: '',
        label: '',
        type: _domain.CustomFieldTypes.TEXT,
        required: false
      }
    })
  });
  const {
    submit
  } = formState;
  const handleSaveField = (0, _react.useCallback)(async () => {
    const {
      isValid,
      data
    } = await submit();
    if (isValid) {
      onSaveField(data);
    }
  }, [onSaveField, submit]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onCloseFlyout,
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    "data-test-subj": `${dataTestSubj}-header`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: "flyoutTitle"
  }, i18n.ADD_CUSTOM_FIELD))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_form.CustomFieldsForm, {
    initialValue: customField,
    onChange: setFormState
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    "data-test-subj": `${dataTestSubj}-footer`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCloseFlyout,
    "data-test-subj": `${dataTestSubj}-cancel`,
    disabled: disabled,
    isLoading: isLoading
  }, i18n.CANCEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: handleSaveField,
    "data-test-subj": `${dataTestSubj}-save`,
    disabled: disabled,
    isLoading: isLoading
  }, i18n.SAVE_FIELD))))));
};
CustomFieldFlyoutComponent.displayName = 'CustomFieldFlyout';
const CustomFieldFlyout = exports.CustomFieldFlyout = /*#__PURE__*/_react.default.memo(CustomFieldFlyoutComponent);