"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateCaseFormFields = exports.CreateCaseForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _title = require("./title");
var _description = require("./description");
var _tags = require("./tags");
var _connector = require("./connector");
var i18n = _interopRequireWildcard(require("./translations"));
var _sync_alerts_toggle = require("./sync_alerts_toggle");
var _timeline_context = require("../timeline_context");
var _insert_timeline = require("../insert_timeline");
var _utils = require("../utils");
var _utils2 = require("../markdown_editor/utils");
var _submit_button = require("./submit_button");
var _form_context = require("./form_context");
var _use_cases_features = require("../../common/use_cases_features");
var _owner_selector = require("./owner_selector");
var _use_cases_context = require("../cases_context/use_cases_context");
var _use_available_owners = require("../app/use_available_owners");
var _severity = require("./severity");
var _assignees = require("./assignees");
var _use_cancel_creation_action = require("./use_cancel_creation_action");
var _cancel_creation_confirmation_modal = require("./cancel_creation_confirmation_modal");
var _category = require("./category");
var _custom_fields = require("./custom_fields");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const containerCss = (euiTheme, big) => big ? (0, _react2.css)`
        ${(0, _eui.logicalCSS)('margin-top', euiTheme.size.xl)};
      ` : (0, _react2.css)`
        ${(0, _eui.logicalCSS)('margin-top', euiTheme.size.base)};
      `;
const empty = [];
const CreateCaseFormFields = exports.CreateCaseFormFields = /*#__PURE__*/_react.default.memo(({
  connectors,
  isLoadingConnectors,
  withSteps,
  draftStorageKey
}) => {
  const {
    owner
  } = (0, _use_cases_context.useCasesContext)();
  const {
    isSubmitting
  } = (0, _hook_form_lib.useFormContext)();
  const {
    isSyncAlertsEnabled,
    caseAssignmentAuthorized
  } = (0, _use_cases_features.useCasesFeatures)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const availableOwners = (0, _use_available_owners.useAvailableCasesOwners)();
  const canShowCaseSolutionSelection = !owner.length && availableOwners.length > 1;
  const firstStep = (0, _react.useMemo)(() => ({
    title: i18n.STEP_ONE_TITLE,
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_title.Title, {
      isLoading: isSubmitting
    }), caseAssignmentAuthorized ? /*#__PURE__*/_react.default.createElement("div", {
      css: containerCss(euiTheme)
    }, /*#__PURE__*/_react.default.createElement(_assignees.Assignees, {
      isLoading: isSubmitting
    })) : null, /*#__PURE__*/_react.default.createElement("div", {
      css: containerCss(euiTheme)
    }, /*#__PURE__*/_react.default.createElement(_tags.Tags, {
      isLoading: isSubmitting
    })), /*#__PURE__*/_react.default.createElement("div", {
      css: containerCss(euiTheme)
    }, /*#__PURE__*/_react.default.createElement(_category.Category, {
      isLoading: isSubmitting
    })), /*#__PURE__*/_react.default.createElement("div", {
      css: containerCss(euiTheme)
    }, /*#__PURE__*/_react.default.createElement(_severity.Severity, {
      isLoading: isSubmitting
    })), canShowCaseSolutionSelection && /*#__PURE__*/_react.default.createElement("div", {
      css: containerCss(euiTheme, true)
    }, /*#__PURE__*/_react.default.createElement(_owner_selector.CreateCaseOwnerSelector, {
      availableOwners: availableOwners,
      isLoading: isSubmitting
    })), /*#__PURE__*/_react.default.createElement("div", {
      css: containerCss(euiTheme, true)
    }, /*#__PURE__*/_react.default.createElement(_description.Description, {
      isLoading: isSubmitting,
      draftStorageKey: draftStorageKey
    })), /*#__PURE__*/_react.default.createElement("div", {
      css: containerCss(euiTheme)
    }, /*#__PURE__*/_react.default.createElement(_custom_fields.CustomFields, {
      isLoading: isSubmitting
    })), /*#__PURE__*/_react.default.createElement("div", {
      css: containerCss(euiTheme)
    }))
  }), [isSubmitting, euiTheme, caseAssignmentAuthorized, canShowCaseSolutionSelection, availableOwners, draftStorageKey]);
  const secondStep = (0, _react.useMemo)(() => ({
    title: i18n.STEP_TWO_TITLE,
    children: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_sync_alerts_toggle.SyncAlertsToggle, {
      isLoading: isSubmitting
    }))
  }), [isSubmitting]);
  const thirdStep = (0, _react.useMemo)(() => ({
    title: i18n.STEP_THREE_TITLE,
    children: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_connector.Connector, {
      connectors: connectors,
      isLoadingConnectors: isLoadingConnectors,
      isLoading: isSubmitting
    }))
  }), [connectors, isLoadingConnectors, isSubmitting]);
  const allSteps = (0, _react.useMemo)(() => [firstStep, ...(isSyncAlertsEnabled ? [secondStep] : []), thirdStep], [isSyncAlertsEnabled, firstStep, secondStep, thirdStep]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isSubmitting && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    css: (0, _react2.css)`
              position: absolute;
              top: 50%;
              left: 50%;
              z-index: 99;
            `,
    "data-test-subj": "create-case-loading-spinner",
    size: "xl"
  }), withSteps ? /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    headingElement: "h2",
    steps: allSteps,
    "data-test-subj": 'case-creation-form-steps'
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, firstStep.children, isSyncAlertsEnabled && secondStep.children, thirdStep.children));
});
CreateCaseFormFields.displayName = 'CreateCaseFormFields';
const CreateCaseForm = exports.CreateCaseForm = /*#__PURE__*/_react.default.memo(({
  withSteps = true,
  afterCaseCreated,
  onCancel,
  onSuccess,
  timelineIntegration,
  attachments,
  initialValue
}) => {
  const {
    owner
  } = (0, _use_cases_context.useCasesContext)();
  const draftStorageKey = (0, _utils2.getMarkdownEditorStorageKey)({
    appId: owner[0],
    caseId: 'createCase',
    commentId: 'description'
  });
  const handleOnConfirmationCallback = () => {
    onCancel();
    (0, _utils.removeItemFromSessionStorage)(draftStorageKey);
  };
  const {
    showConfirmationModal,
    onOpenModal,
    onConfirmModal,
    onCancelModal
  } = (0, _use_cancel_creation_action.useCancelCreationAction)({
    onConfirmationCallback: handleOnConfirmationCallback
  });
  const handleOnSuccess = theCase => {
    (0, _utils.removeItemFromSessionStorage)(draftStorageKey);
    return onSuccess(theCase);
  };
  return /*#__PURE__*/_react.default.createElement(_timeline_context.CasesTimelineIntegrationProvider, {
    timelineIntegration: timelineIntegration
  }, /*#__PURE__*/_react.default.createElement(_form_context.FormContext, {
    afterCaseCreated: afterCaseCreated,
    onSuccess: handleOnSuccess,
    attachments: attachments,
    initialValue: initialValue
  }, /*#__PURE__*/_react.default.createElement(CreateCaseFormFields, {
    connectors: empty,
    isLoadingConnectors: false,
    withSteps: withSteps,
    draftStorageKey: draftStorageKey
  }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexEnd",
    gutterSize: "l",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "create-case-cancel",
    iconType: "cross",
    onClick: onOpenModal,
    size: "s"
  }, i18n.CANCEL), showConfirmationModal && /*#__PURE__*/_react.default.createElement(_cancel_creation_confirmation_modal.CancelCreationConfirmationModal, {
    title: i18n.MODAL_TITLE,
    onConfirm: onConfirmModal,
    onCancel: onCancelModal
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_submit_button.SubmitCaseButton, null)))), /*#__PURE__*/_react.default.createElement(_insert_timeline.InsertTimeline, {
    fieldName: _description.fieldName
  })));
});
CreateCaseForm.displayName = 'CreateCaseForm';