"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Assignees = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _userProfileComponents = require("@kbn/user-profile-components");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _constants = require("../../../common/constants");
var _use_suggest_user_profiles = require("../../containers/user_profiles/use_suggest_user_profiles");
var _use_cases_context = require("../cases_context/use_cases_context");
var _use_get_current_user_profile = require("../../containers/user_profiles/use_get_current_user_profile");
var _optional_field_label = require("./optional_field_label");
var i18n = _interopRequireWildcard(require("./translations"));
var _sort = require("../user_profiles/sort");
var _use_available_owners = require("../app/use_available_owners");
var _permissions = require("../../utils/permissions");
var _use_is_user_typing = require("../../common/use_is_user_typing");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getConfig = () => ({
  label: i18n.ASSIGNEES,
  defaultValue: [],
  validations: [{
    validator: ({
      value
    }) => {
      if (value.length > _constants.MAX_ASSIGNEES_PER_CASE) {
        return {
          message: i18n.INVALID_ASSIGNEES
        };
      }
    }
  }]
});
const userProfileToComboBoxOption = userProfile => ({
  label: (0, _userProfileComponents.getUserDisplayName)(userProfile.user),
  value: userProfile.uid,
  key: userProfile.uid,
  user: userProfile.user,
  data: userProfile.data
});
const comboBoxOptionToAssignee = option => ({
  uid: option.value
});
const AssigneesFieldComponent = /*#__PURE__*/_react.default.memo(({
  field,
  isLoading,
  isDisabled,
  options,
  currentUserProfile,
  selectedOptions,
  setSelectedOptions,
  onSearchComboChange
}) => {
  const {
    setValue
  } = field;
  const {
    isInvalid,
    errorMessage
  } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field);
  const onComboChange = (0, _react.useCallback)(currentOptions => {
    setSelectedOptions(currentOptions);
    setValue(currentOptions.map(option => comboBoxOptionToAssignee(option)));
  }, [setSelectedOptions, setValue]);
  const onSelfAssign = (0, _react.useCallback)(() => {
    var _selectedOptions$map;
    if (!currentUserProfile) {
      return;
    }
    setSelectedOptions(prev => [...(prev !== null && prev !== void 0 ? prev : []), userProfileToComboBoxOption(currentUserProfile)]);
    setValue([...((_selectedOptions$map = selectedOptions === null || selectedOptions === void 0 ? void 0 : selectedOptions.map(option => comboBoxOptionToAssignee(option))) !== null && _selectedOptions$map !== void 0 ? _selectedOptions$map : []), {
      uid: currentUserProfile.uid
    }]);
  }, [currentUserProfile, selectedOptions, setSelectedOptions, setValue]);
  const renderOption = (0, _react.useCallback)((option, searchValue, contentClassName) => {
    const {
      user,
      data
    } = option;
    const displayName = (0, _userProfileComponents.getUserDisplayName)(user);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "flexStart",
      gutterSize: "s",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_userProfileComponents.UserAvatar, {
      user: user,
      avatar: data.avatar,
      size: "s"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "spaceBetween",
      gutterSize: "none",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: searchValue,
      className: contentClassName
    }, displayName)), user.email && user.email !== displayName ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: 'subdued'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: searchValue,
      className: contentClassName
    }, user.email))) : null));
  }, []);
  const isCurrentUserSelected = Boolean(selectedOptions === null || selectedOptions === void 0 ? void 0 : selectedOptions.find(option => option.value === (currentUserProfile === null || currentUserProfile === void 0 ? void 0 : currentUserProfile.uid)));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "createCaseAssignees",
    fullWidth: true,
    label: i18n.ASSIGNEES,
    labelAppend: _optional_field_label.OptionalFieldLabel,
    helpText: currentUserProfile ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "create-case-assign-yourself-link",
      onClick: onSelfAssign,
      disabled: isCurrentUserSelected
    }, i18n.ASSIGN_YOURSELF) : undefined,
    isInvalid: isInvalid,
    error: errorMessage
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    async: true,
    isLoading: isLoading,
    options: options,
    "data-test-subj": "createCaseAssigneesComboBox",
    selectedOptions: selectedOptions,
    isDisabled: isDisabled,
    onChange: onComboChange,
    onSearchChange: onSearchComboChange,
    renderOption: renderOption,
    rowHeight: 35
  }));
});
AssigneesFieldComponent.displayName = 'AssigneesFieldComponent';
const AssigneesComponent = ({
  isLoading: isLoadingForm
}) => {
  var _bringCurrentUserToFr, _bringCurrentUserToFr2;
  const {
    owner: owners
  } = (0, _use_cases_context.useCasesContext)();
  const availableOwners = (0, _use_available_owners.useAvailableCasesOwners)((0, _permissions.getAllPermissionsExceptFrom)('delete'));
  const [searchTerm, setSearchTerm] = (0, _react.useState)('');
  const [selectedOptions, setSelectedOptions] = (0, _react.useState)();
  const {
    isUserTyping,
    onContentChange,
    onDebounce
  } = (0, _use_is_user_typing.useIsUserTyping)();
  const hasOwners = owners.length > 0;
  const {
    data: currentUserProfile,
    isLoading: isLoadingCurrentUserProfile
  } = (0, _use_get_current_user_profile.useGetCurrentUserProfile)();
  const {
    data: userProfiles,
    isLoading: isLoadingSuggest,
    isFetching: isFetchingSuggest
  } = (0, _use_suggest_user_profiles.useSuggestUserProfiles)({
    name: searchTerm,
    owners: hasOwners ? owners : availableOwners,
    onDebounce
  });
  const options = (_bringCurrentUserToFr = (_bringCurrentUserToFr2 = (0, _sort.bringCurrentUserToFrontAndSort)(currentUserProfile, userProfiles)) === null || _bringCurrentUserToFr2 === void 0 ? void 0 : _bringCurrentUserToFr2.map(userProfile => userProfileToComboBoxOption(userProfile))) !== null && _bringCurrentUserToFr !== void 0 ? _bringCurrentUserToFr : [];
  const onSearchComboChange = value => {
    if (!(0, _lodash.isEmpty)(value)) {
      setSearchTerm(value);
    }
    onContentChange(value);
  };
  const isLoading = isLoadingForm || isLoadingCurrentUserProfile || isLoadingSuggest || isFetchingSuggest || isUserTyping;
  const isDisabled = isLoadingForm || isLoadingCurrentUserProfile;
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "assignees",
    config: getConfig(),
    component: AssigneesFieldComponent,
    componentProps: {
      isLoading,
      isDisabled,
      selectedOptions,
      setSelectedOptions,
      options,
      onSearchComboChange,
      currentUserProfile,
      isUserTyping
    }
  });
};
AssigneesComponent.displayName = 'AssigneesComponent';
const Assignees = exports.Assignees = /*#__PURE__*/(0, _react.memo)(AssigneesComponent);