"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetFieldsByIssueType = void 0;
var _reactQuery = require("@tanstack/react-query");
var _lodash = require("lodash");
var _use_cases_toast = require("../../../common/use_cases_toast");
var _api = require("./api");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants = require("../constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetFieldsByIssueType = ({
  http,
  connector,
  issueType
}) => {
  var _connector$id;
  const {
    showErrorToast
  } = (0, _use_cases_toast.useCasesToast)();
  return (0, _reactQuery.useQuery)(_constants.connectorsQueriesKeys.jiraGetFieldsByIssueType((_connector$id = connector === null || connector === void 0 ? void 0 : connector.id) !== null && _connector$id !== void 0 ? _connector$id : '', issueType !== null && issueType !== void 0 ? issueType : ''), ({
    signal
  }) => {
    var _connector$id2;
    return (0, _api.getFieldsByIssueType)({
      http,
      signal,
      connectorId: (_connector$id2 = connector === null || connector === void 0 ? void 0 : connector.id) !== null && _connector$id2 !== void 0 ? _connector$id2 : '',
      id: issueType !== null && issueType !== void 0 ? issueType : ''
    });
  }, {
    enabled: Boolean(connector) && !(0, _lodash.isEmpty)(issueType),
    staleTime: 60 * 1000,
    // one minute
    onSuccess: res => {
      if (res.status && res.status === 'error') {
        var _res$serviceMessage;
        showErrorToast(new Error(i18n.FIELDS_API_ERROR), {
          title: i18n.FIELDS_API_ERROR,
          toastMessage: `${(_res$serviceMessage = res.serviceMessage) !== null && _res$serviceMessage !== void 0 ? _res$serviceMessage : res.message}`
        });
      }
    },
    onError: error => {
      showErrorToast(error, {
        title: i18n.FIELDS_API_ERROR
      });
    }
  });
};
exports.useGetFieldsByIssueType = useGetFieldsByIssueType;