"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigureCases = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _common = require("@kbn/actions-plugin/common");
var _kibana = require("../../common/lib/kibana");
var _use_action_types = require("../../containers/configure/use_action_types");
var _use_get_case_configuration = require("../../containers/configure/use_get_case_configuration");
var _connectors = require("./connectors");
var _closure_options = require("./closure_options");
var _utils = require("./utils");
var i18n = _interopRequireWildcard(require("./translations"));
var _utils2 = require("../utils");
var _header_page = require("../header_page");
var _use_cases_context = require("../cases_context/use_cases_context");
var _use_breadcrumbs = require("../use_breadcrumbs");
var _navigation = require("../../common/navigation");
var _custom_fields = require("../custom_fields");
var _flyout = require("../custom_fields/flyout");
var _use_get_supported_action_connectors = require("../../containers/configure/use_get_supported_action_connectors");
var _use_persist_configuration = require("../../containers/configure/use_persist_configuration");
var _utils3 = require("../custom_fields/utils");
var _use_license = require("../../common/use_license");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sectionWrapperCss = (0, _react2.css)`
  box-sizing: content-box;
  max-width: 1175px;
  width: 100%;
`;
const getFormWrapperCss = euiTheme => (0, _react2.css)`
  padding-top: ${euiTheme.size.xl};
  padding-bottom: ${euiTheme.size.xl};
  .euiFlyout {
    z-index: ${Number(euiTheme.levels.navigation) + 1};
  }
`;
const ConfigureCases = exports.ConfigureCases = /*#__PURE__*/_react.default.memo(() => {
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const {
    triggersActionsUi
  } = (0, _kibana.useKibana)().services;
  (0, _use_breadcrumbs.useCasesBreadcrumbs)(_navigation.CasesDeepLinkId.casesConfigure);
  const license = (0, _use_license.useLicense)();
  const hasMinimumLicensePermissions = license.isAtLeastGold();
  const [connectorIsValid, setConnectorIsValid] = (0, _react.useState)(true);
  const [addFlyoutVisible, setAddFlyoutVisibility] = (0, _react.useState)(false);
  const [editFlyoutVisible, setEditFlyoutVisibility] = (0, _react.useState)(false);
  const [editedConnectorItem, setEditedConnectorItem] = (0, _react.useState)(null);
  const [customFieldFlyoutVisible, setCustomFieldFlyoutVisibility] = (0, _react.useState)(false);
  const [customFieldToEdit, setCustomFieldToEdit] = (0, _react.useState)(null);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    data: {
      id: configurationId,
      version: configurationVersion,
      closureType,
      connector,
      mappings,
      customFields
    },
    isLoading: loadingCaseConfigure,
    refetch: refetchCaseConfigure
  } = (0, _use_get_case_configuration.useGetCaseConfiguration)();
  const {
    mutate: persistCaseConfigure,
    mutateAsync: persistCaseConfigureAsync,
    isLoading: isPersistingConfiguration
  } = (0, _use_persist_configuration.usePersistConfiguration)();
  const isLoadingCaseConfiguration = loadingCaseConfigure || isPersistingConfiguration;
  const {
    isLoading: isLoadingConnectors,
    data: connectors = [],
    refetch: refetchConnectors
  } = (0, _use_get_supported_action_connectors.useGetSupportedActionConnectors)();
  const {
    isLoading: isLoadingActionTypes,
    data: actionTypes = [],
    refetch: refetchActionTypes
  } = (0, _use_action_types.useGetActionTypes)();
  const onConnectorUpdated = (0, _react.useCallback)(async updatedConnector => {
    setEditedConnectorItem(updatedConnector);
    refetchConnectors();
    refetchActionTypes();
    refetchCaseConfigure();
  }, [refetchActionTypes, refetchCaseConfigure, refetchConnectors, setEditedConnectorItem]);
  const onConnectorCreated = (0, _react.useCallback)(async createdConnector => {
    const caseConnector = (0, _utils.normalizeActionConnector)(createdConnector);
    await persistCaseConfigureAsync({
      connector: caseConnector,
      closureType,
      customFields,
      id: configurationId,
      version: configurationVersion
    });
    onConnectorUpdated(createdConnector);
  }, [persistCaseConfigureAsync, closureType, customFields, configurationId, configurationVersion, onConnectorUpdated]);
  const isLoadingAny = isLoadingConnectors || isPersistingConfiguration || loadingCaseConfigure || isLoadingActionTypes;
  const updateConnectorDisabled = isLoadingAny || !connectorIsValid || connector.id === 'none';
  const onClickUpdateConnector = (0, _react.useCallback)(() => {
    setEditFlyoutVisibility(true);
  }, []);
  const onCloseAddFlyout = (0, _react.useCallback)(() => setAddFlyoutVisibility(false), [setAddFlyoutVisibility]);
  const onCloseEditFlyout = (0, _react.useCallback)(() => setEditFlyoutVisibility(false), []);
  const onChangeConnector = (0, _react.useCallback)(id => {
    if (id === 'add-connector') {
      setAddFlyoutVisibility(true);
      return;
    }
    const actionConnector = (0, _utils2.getConnectorById)(id, connectors);
    const caseConnector = actionConnector != null ? (0, _utils.normalizeActionConnector)(actionConnector) : (0, _utils.getNoneConnector)();
    persistCaseConfigure({
      connector: caseConnector,
      closureType,
      customFields,
      id: configurationId,
      version: configurationVersion
    });
  }, [connectors, persistCaseConfigure, closureType, customFields, configurationId, configurationVersion]);
  const onChangeClosureType = (0, _react.useCallback)(type => {
    persistCaseConfigure({
      connector,
      customFields,
      id: configurationId,
      version: configurationVersion,
      closureType: type
    });
  }, [configurationId, configurationVersion, connector, customFields, persistCaseConfigure]);
  (0, _react.useEffect)(() => {
    if (!isLoadingConnectors && connector.id !== 'none' && !connectors.some(c => c.id === connector.id)) {
      setConnectorIsValid(false);
    } else if (!isLoadingConnectors && (connector.id === 'none' || connectors.some(c => c.id === connector.id))) {
      setConnectorIsValid(true);
    }
  }, [connectors, connector, isLoadingConnectors]);
  (0, _react.useEffect)(() => {
    if (!isLoadingConnectors && connector.id !== 'none') {
      setEditedConnectorItem((0, _utils.normalizeCaseConnector)(connectors, connector));
    }
  }, [connectors, connector, isLoadingConnectors]);
  const ConnectorAddFlyout = (0, _react.useMemo)(() => addFlyoutVisible ? triggersActionsUi.getAddConnectorFlyout({
    onClose: onCloseAddFlyout,
    featureId: _common.CasesConnectorFeatureId,
    onConnectorCreated
  }) : null,
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [addFlyoutVisible]);
  const ConnectorEditFlyout = (0, _react.useMemo)(() => editedConnectorItem && editFlyoutVisible ? triggersActionsUi.getEditConnectorFlyout({
    connector: editedConnectorItem,
    onClose: onCloseEditFlyout,
    onConnectorUpdated
  }) : null,
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [connector.id, editedConnectorItem, editFlyoutVisible]);
  const onAddCustomFields = (0, _react.useCallback)(() => {
    setCustomFieldFlyoutVisibility(true);
  }, [setCustomFieldFlyoutVisibility]);
  const onDeleteCustomField = (0, _react.useCallback)(key => {
    const remainingCustomFields = customFields.filter(field => field.key !== key);
    persistCaseConfigure({
      connector,
      customFields: [...remainingCustomFields],
      id: configurationId,
      version: configurationVersion,
      closureType
    });
  }, [closureType, configurationId, configurationVersion, connector, customFields, persistCaseConfigure]);
  const onEditCustomField = (0, _react.useCallback)(key => {
    const selectedCustomField = customFields.find(item => item.key === key);
    if (selectedCustomField) {
      setCustomFieldToEdit(selectedCustomField);
    }
    setCustomFieldFlyoutVisibility(true);
  }, [setCustomFieldFlyoutVisibility, setCustomFieldToEdit, customFields]);
  const onCloseAddFieldFlyout = (0, _react.useCallback)(() => {
    setCustomFieldFlyoutVisibility(false);
    setCustomFieldToEdit(null);
  }, [setCustomFieldFlyoutVisibility, setCustomFieldToEdit]);
  const onSaveCustomField = (0, _react.useCallback)(customFieldData => {
    const updatedFields = (0, _utils3.addOrReplaceCustomField)(customFields, customFieldData);
    persistCaseConfigure({
      connector,
      customFields: updatedFields,
      id: configurationId,
      version: configurationVersion,
      closureType
    });
    setCustomFieldFlyoutVisibility(false);
    setCustomFieldToEdit(null);
  }, [closureType, configurationId, configurationVersion, connector, customFields, persistCaseConfigure]);
  const CustomFieldAddFlyout = customFieldFlyoutVisible ? /*#__PURE__*/_react.default.createElement(_flyout.CustomFieldFlyout, {
    isLoading: loadingCaseConfigure || isPersistingConfiguration,
    disabled: !permissions.create || !permissions.update || loadingCaseConfigure || isPersistingConfiguration,
    customField: customFieldToEdit,
    onCloseFlyout: onCloseAddFieldFlyout,
    onSaveField: onSaveCustomField
  }) : null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    restrictWidth: true
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    showBackButton: true,
    "data-test-subj": "case-configure-title",
    title: i18n.CONFIGURE_CASES_PAGE_TITLE
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    restrictWidth: true
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: getFormWrapperCss(euiTheme)
  }, hasMinimumLicensePermissions && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !connectorIsValid && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    css: sectionWrapperCss
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18n.WARNING_NO_CONNECTOR_TITLE,
    color: "warning",
    iconType: "help",
    "data-test-subj": "configure-cases-warning-callout"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The selected connector has been deleted or you do not have the {appropriateLicense} to use it. Either select a different connector or create a new one.",
    id: "xpack.cases.configure.connectorDeletedOrLicenseWarning",
    values: {
      appropriateLicense: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/subscriptions",
        target: "_blank"
      }, i18n.LINK_APPROPRIATE_LICENSE)
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  })), /*#__PURE__*/_react.default.createElement("div", {
    css: sectionWrapperCss
  }, /*#__PURE__*/_react.default.createElement(_closure_options.ClosureOptions, {
    closureTypeSelected: closureType,
    disabled: isPersistingConfiguration || isLoadingConnectors || !permissions.update,
    onChangeClosureType: onChangeClosureType
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: sectionWrapperCss
  }, /*#__PURE__*/_react.default.createElement(_connectors.Connectors, {
    actionTypes: actionTypes,
    connectors: connectors !== null && connectors !== void 0 ? connectors : [],
    disabled: isPersistingConfiguration || isLoadingConnectors || !permissions.update,
    handleShowEditFlyout: onClickUpdateConnector,
    isLoading: isLoadingAny,
    mappings: mappings,
    onChangeConnector: onChangeConnector,
    selectedConnector: connector,
    updateConnectorDisabled: updateConnectorDisabled || !permissions.update
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  })), /*#__PURE__*/_react.default.createElement("div", {
    css: sectionWrapperCss
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_custom_fields.CustomFields, {
    customFields: customFields,
    isLoading: isLoadingCaseConfiguration,
    disabled: isLoadingCaseConfiguration,
    handleAddCustomField: onAddCustomFields,
    handleDeleteCustomField: onDeleteCustomField,
    handleEditCustomField: onEditCustomField
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), ConnectorAddFlyout, ConnectorEditFlyout, CustomFieldAddFlyout)));
});
ConfigureCases.displayName = 'ConfigureCases';