"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.schema = exports.EditTags = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var i18n = _interopRequireWildcard(require("../../tags/translations"));
var _use_get_tags = require("../../../containers/use_get_tags");
var _tags = require("../../tags/tags");
var _use_cases_context = require("../../cases_context/use_cases_context");
var _schema = require("../../create/schema");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const schema = exports.schema = {
  tags: _schema.schemaTags
};
const EditTags = exports.EditTags = /*#__PURE__*/_react.default.memo(({
  isLoading,
  onSubmit,
  tags
}) => {
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const initialState = {
    tags
  };
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    defaultValue: initialState,
    options: {
      stripEmptyFields: false
    },
    schema
  });
  const {
    submit
  } = form;
  const [isEditTags, setIsEditTags] = (0, _react.useState)(false);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const onSubmitTags = (0, _react.useCallback)(async () => {
    const {
      isValid,
      data: newData
    } = await submit();
    if (isValid && newData.tags) {
      const trimmedTags = newData.tags.map(tag => tag.trim());
      onSubmit(trimmedTags);
      form.reset({
        defaultValue: newData
      });
      setIsEditTags(false);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [onSubmit, submit]);
  const {
    data: tagOptions = []
  } = (0, _use_get_tags.useGetTags)();
  const options = tagOptions.map(label => ({
    label
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    justifyContent: "spaceBetween",
    responsive: false,
    "data-test-subj": "case-view-tag-list"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, i18n.TAGS))), isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    "data-test-subj": "tag-list-loading"
  }), !isLoading && permissions.update && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "tag-list-edit",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "tag-list-edit-button",
    "aria-label": i18n.EDIT_TAGS_ARIA,
    iconType: 'pencil',
    onClick: () => setIsEditTags(true)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react2.css)`
          width: 100%;
          p {
            font-size: ${euiTheme.size.m};
            margin-block-end: unset;
          }
        `,
    gutterSize: "none",
    "data-test-subj": "case-tags"
  }, tags.length === 0 && !isEditTags && /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "no-tags"
  }, i18n.NO_TAGS), !isEditTags && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_tags.Tags, {
    tags: tags,
    color: "hollow"
  })), isEditTags && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react2.css)`
              & {
                max-width: 100%;
                @media only screen and (max-width: ${euiTheme.breakpoint.m}) {
                  flex-direction: row;
                }
              }
            `,
    "data-test-subj": "edit-tags",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    form: form
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "tags",
    component: _components.ComboBoxField,
    componentProps: {
      idAria: 'caseTags',
      'data-test-subj': 'caseTags',
      euiFieldProps: {
        fullWidth: true,
        placeholder: '',
        options,
        noSuggestions: false,
        customOptionText: i18n.ADD_TAG_CUSTOM_OPTION_LABEL_COMBO_BOX
      }
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "success",
    "data-test-subj": "edit-tags-submit",
    fill: true,
    iconType: "save",
    onClick: onSubmitTags,
    size: "s"
  }, i18n.SAVE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "edit-tags-cancel",
    iconType: "cross",
    onClick: () => setIsEditTags(false),
    size: "s"
  }, i18n.CANCEL)))))));
});
EditTags.displayName = 'EditTags';