"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.CasesRoutes = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _reactQueryDevtools = require("@tanstack/react-query-devtools");
var _eui = require("@elastic/eui");
var _all_cases = require("../all_cases");
var _create = require("../create");
var _configure_cases = require("../configure_cases");
var _use_cases_context = require("../cases_context/use_cases_context");
var _navigation = require("../../common/navigation");
var _no_privileges = require("../no_privileges");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_readonly_header = require("./use_readonly_header");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CaseViewLazy = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../case_view'))));
const CasesRoutesComponent = ({
  actionsNavigation,
  ruleDetailsNavigation,
  showAlertDetails,
  useFetchAlertData,
  refreshRef,
  timelineIntegration
}) => {
  const {
    basePath,
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const {
    navigateToAllCases
  } = (0, _navigation.useAllCasesNavigation)();
  const {
    navigateToCaseView
  } = (0, _navigation.useCaseViewNavigation)();
  (0, _use_readonly_header.useReadonlyHeader)();
  const onCreateCaseSuccess = (0, _react.useCallback)(async ({
    id
  }) => navigateToCaseView({
    detailName: id
  }), [navigateToCaseView]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_reactQueryDevtools.ReactQueryDevtools, {
    initialIsOpen: false
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    strict: true,
    exact: true,
    path: basePath
  }, /*#__PURE__*/_react.default.createElement(_all_cases.AllCases, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: (0, _navigation.getCreateCasePath)(basePath)
  }, permissions.create ? /*#__PURE__*/_react.default.createElement(_create.CreateCase, {
    onSuccess: onCreateCaseSuccess,
    onCancel: navigateToAllCases,
    timelineIntegration: timelineIntegration
  }) : /*#__PURE__*/_react.default.createElement(_no_privileges.NoPrivilegesPage, {
    pageName: i18n.CREATE_CASE_PAGE_NAME
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: (0, _navigation.getCasesConfigurePath)(basePath)
  }, permissions.settings ? /*#__PURE__*/_react.default.createElement(_configure_cases.ConfigureCases, null) : /*#__PURE__*/_react.default.createElement(_no_privileges.NoPrivilegesPage, {
    pageName: i18n.CONFIGURE_CASES_PAGE_NAME
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: [(0, _navigation.getCaseViewWithCommentPath)(basePath), (0, _navigation.getCaseViewPath)(basePath)]
  }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
  }, /*#__PURE__*/_react.default.createElement(CaseViewLazy, {
    actionsNavigation: actionsNavigation,
    ruleDetailsNavigation: ruleDetailsNavigation,
    showAlertDetails: showAlertDetails,
    useFetchAlertData: useFetchAlertData,
    refreshRef: refreshRef,
    timelineIntegration: timelineIntegration
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: basePath
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: basePath
  }))));
};
CasesRoutesComponent.displayName = 'CasesRoutes';
const CasesRoutes = exports.default = exports.CasesRoutes = /*#__PURE__*/_react.default.memo(CasesRoutesComponent);
// eslint-disable-next-line import/no-default-export