"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCasesColumns = exports.ExternalServiceColumn = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _status = require("@kbn/cases-components/src/status/status");
var _domain = require("../../../common/types/domain");
var _empty_value = require("../empty_value");
var _formatted_date = require("../formatted_date");
var _links = require("../links");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_actions = require("./use_actions");
var _use_cases_columns_configuration = require("./use_cases_columns_configuration");
var _kibana = require("../../common/lib/kibana");
var _truncated_text = require("../truncated_text");
var _utils = require("../utils");
var _config = require("../severity/config");
var _assignees_column = require("./assignees_column");
var _builder = require("../custom_fields/builder");
var _use_get_case_configuration = require("../../containers/configure/use_get_case_configuration");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LINE_CLAMP = 3;
const getLineClampedCss = (0, _react2.css)`
  text-overflow: ellipsis;
  display: -webkit-box;
  -webkit-line-clamp: ${LINE_CLAMP};
  -webkit-box-orient: vertical;
  overflow: hidden;
  word-break: normal;
`;
const renderStringField = (field, dataTestSubj) => field != null ? /*#__PURE__*/_react.default.createElement("span", {
  "data-test-subj": dataTestSubj
}, field) : (0, _empty_value.getEmptyCellValue)();
const useCasesColumns = ({
  userProfiles,
  isSelectorView,
  connectors = [],
  onRowClick,
  disableActions = false,
  selectedColumns
}) => {
  const casesColumnsConfig = (0, _use_cases_columns_configuration.useCasesColumnsConfiguration)(isSelectorView);
  const {
    actions
  } = (0, _use_actions.useActions)({
    disableActions
  });
  const {
    data: {
      customFields
    },
    isFetching: isLoadingColumns
  } = (0, _use_get_case_configuration.useGetCaseConfiguration)();
  const assignCaseAction = (0, _react.useCallback)(async theCase => {
    if (onRowClick) {
      onRowClick(theCase);
    }
  }, [onRowClick]);
  const columnsDict = (0, _react.useMemo)(() => ({
    title: {
      field: casesColumnsConfig.title.field,
      name: casesColumnsConfig.title.name,
      sortable: true,
      render: (title, theCase) => {
        if (theCase.id != null && theCase.title != null) {
          const caseDetailsLinkComponent = isSelectorView ? theCase.title : /*#__PURE__*/_react.default.createElement(_links.CaseDetailsLink, {
            detailName: theCase.id,
            title: theCase.title
          }, /*#__PURE__*/_react.default.createElement(_truncated_text.TruncatedText, {
            text: theCase.title
          }));
          return caseDetailsLinkComponent;
        }
        return (0, _empty_value.getEmptyCellValue)();
      },
      width: !isSelectorView ? '20%' : '55%'
    },
    assignees: {
      field: casesColumnsConfig.assignees.field,
      name: casesColumnsConfig.assignees.name,
      render: assignees => /*#__PURE__*/_react.default.createElement(_assignees_column.AssigneesColumn, {
        assignees: assignees,
        userProfiles: userProfiles
      })
    },
    tags: {
      field: casesColumnsConfig.tags.field,
      name: casesColumnsConfig.tags.name,
      render: tags => {
        if (tags != null && tags.length > 0) {
          const clampedBadges = /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
            "data-test-subj": "case-table-column-tags",
            css: getLineClampedCss,
            gutterSize: "xs"
          }, tags.map((tag, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
            css: (0, _react2.css)`
                      max-width: 100px;
                    `,
            color: "hollow",
            key: `${tag}-${i}`,
            "data-test-subj": `case-table-column-tags-${tag}`
          }, tag)));
          const unclampedBadges = /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
            "data-test-subj": "case-table-column-tags"
          }, tags.map((tag, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
            color: "hollow",
            key: `${tag}-${i}`,
            "data-test-subj": `case-table-column-tags-${tag}`
          }, tag)));
          return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            "data-test-subj": "case-table-column-tags-tooltip",
            position: "left",
            content: unclampedBadges
          }, clampedBadges);
        }
        return (0, _empty_value.getEmptyCellValue)();
      },
      width: '12%'
    },
    totalAlerts: {
      field: casesColumnsConfig.totalAlerts.field,
      name: casesColumnsConfig.totalAlerts.name,
      align: _eui.RIGHT_ALIGNMENT,
      render: totalAlerts => totalAlerts != null ? renderStringField(`${totalAlerts}`, `case-table-column-alertsCount`) : (0, _empty_value.getEmptyCellValue)(),
      width: !isSelectorView ? '80px' : '55px'
    },
    totalComment: {
      field: casesColumnsConfig.totalComment.field,
      name: casesColumnsConfig.totalComment.name,
      align: _eui.RIGHT_ALIGNMENT,
      render: totalComment => totalComment != null ? renderStringField(`${totalComment}`, `case-table-column-commentCount`) : (0, _empty_value.getEmptyCellValue)(),
      width: '90px'
    },
    category: {
      field: casesColumnsConfig.category.field,
      name: casesColumnsConfig.category.name,
      sortable: true,
      render: category => {
        if (category != null) {
          return /*#__PURE__*/_react.default.createElement("span", {
            "data-test-subj": `case-table-column-category-${category}`
          }, category);
        }
        return (0, _empty_value.getEmptyCellValue)();
      },
      width: '120px'
    },
    closedAt: {
      field: casesColumnsConfig.closedAt.field,
      name: casesColumnsConfig.closedAt.name,
      sortable: true,
      render: closedAt => {
        if (closedAt != null) {
          return /*#__PURE__*/_react.default.createElement("span", {
            "data-test-subj": `case-table-column-closedAt`
          }, /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
            value: closedAt
          }));
        }
        return (0, _empty_value.getEmptyCellValue)();
      }
    },
    createdAt: {
      field: casesColumnsConfig.createdAt.field,
      name: casesColumnsConfig.createdAt.name,
      sortable: true,
      render: createdAt => {
        if (createdAt != null) {
          return /*#__PURE__*/_react.default.createElement("span", {
            "data-test-subj": `case-table-column-createdAt`
          }, /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
            value: createdAt,
            stripMs: true
          }));
        }
        return (0, _empty_value.getEmptyCellValue)();
      }
    },
    updatedAt: {
      field: casesColumnsConfig.updatedAt.field,
      name: casesColumnsConfig.updatedAt.name,
      sortable: true,
      render: updatedAt => {
        if (updatedAt != null) {
          return /*#__PURE__*/_react.default.createElement("span", {
            "data-test-subj": "case-table-column-updatedAt"
          }, /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
            value: updatedAt,
            stripMs: true
          }));
        }
        return (0, _empty_value.getEmptyCellValue)();
      }
    },
    externalIncident: {
      // no field
      name: casesColumnsConfig.externalIncident.name,
      render: theCase => {
        if (theCase.id != null) {
          return /*#__PURE__*/_react.default.createElement(ExternalServiceColumn, {
            theCase: theCase,
            connectors: connectors
          });
        }
        return (0, _empty_value.getEmptyCellValue)();
      }
    },
    status: {
      field: casesColumnsConfig.status.field,
      name: casesColumnsConfig.status.name,
      sortable: true,
      render: status => {
        if (status != null) {
          return /*#__PURE__*/_react.default.createElement(_status.Status, {
            status: status
          });
        }
        return (0, _empty_value.getEmptyCellValue)();
      },
      width: '110px'
    },
    severity: {
      field: casesColumnsConfig.severity.field,
      name: casesColumnsConfig.severity.name,
      sortable: true,
      render: severity => {
        if (severity != null) {
          const severityData = _config.severities[severity !== null && severity !== void 0 ? severity : _domain.CaseSeverity.LOW];
          return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
            "data-test-subj": `case-table-column-severity-${severity}`,
            color: severityData.color
          }, severityData.label);
        }
        return (0, _empty_value.getEmptyCellValue)();
      },
      width: '90px'
    },
    assignCaseAction: {
      // no field
      align: _eui.RIGHT_ALIGNMENT,
      render: theCase => {
        if (theCase.id != null) {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
            "data-test-subj": `cases-table-row-select-${theCase.id}`,
            onClick: () => {
              assignCaseAction(theCase);
            },
            size: "s"
          }, i18n.SELECT);
        }
        return (0, _empty_value.getEmptyCellValue)();
      }
    }
  }), [assignCaseAction, casesColumnsConfig, connectors, isSelectorView, userProfiles]);

  // we need to extend the columnsDict with the columns of
  // the customFields
  customFields.forEach(({
    key,
    type,
    label
  }) => {
    if (type in _builder.builderMap) {
      const columnDefinition = _builder.builderMap[type]().getEuiTableColumn({
        label
      });
      columnsDict[key] = {
        ...columnDefinition,
        render: theCase => {
          const customField = theCase.customFields.find(element => element.key === key && element.value !== null);
          if (!customField) {
            return (0, _empty_value.getEmptyCellValue)();
          }
          return columnDefinition.render(customField);
        }
      };
    }
  });
  const columns = [];
  selectedColumns.forEach(({
    field,
    isChecked
  }) => {
    if (field in columnsDict && (isChecked || isSelectorView) && casesColumnsConfig[field].canDisplay) {
      columns.push(columnsDict[field]);
    }
  });
  if (isSelectorView) {
    columns.push(columnsDict.assignCaseAction);
  } else if (actions) {
    columns.push(actions);
  }
  return {
    columns,
    isLoadingColumns
  };
};
exports.useCasesColumns = useCasesColumns;
const iconWrapperCss = (0, _react2.css)`
  svg {
    height: 20px !important;
    position: relative;
    top: 3px;
    width: 20px !important;
  }
`;
const ExternalServiceColumn = ({
  theCase,
  connectors
}) => {
  var _theCase$externalServ2, _theCase$externalServ3, _theCase$externalServ4, _theCase$externalServ5, _theCase$externalServ6, _theCase$externalServ7, _theCase$externalServ8;
  const {
    triggersActionsUi
  } = (0, _kibana.useKibana)().services;
  const {
    actions
  } = (0, _kibana.useApplicationCapabilities)();
  if (theCase.externalService == null) {
    return renderStringField(i18n.NOT_PUSHED, `case-table-column-external-notPushed`);
  }
  const lastPushedConnector = connectors.find(connector => {
    var _theCase$externalServ;
    return connector.id === ((_theCase$externalServ = theCase.externalService) === null || _theCase$externalServ === void 0 ? void 0 : _theCase$externalServ.connectorId);
  });
  const lastCaseUpdate = theCase.updatedAt != null ? new Date(theCase.updatedAt) : null;
  const lastCasePush = ((_theCase$externalServ2 = theCase.externalService) === null || _theCase$externalServ2 === void 0 ? void 0 : _theCase$externalServ2.pushedAt) != null ? new Date((_theCase$externalServ3 = theCase.externalService) === null || _theCase$externalServ3 === void 0 ? void 0 : _theCase$externalServ3.pushedAt) : null;
  const hasDataToPush = lastCasePush === null || lastCaseUpdate != null && lastCasePush.getTime() < (lastCaseUpdate === null || lastCaseUpdate === void 0 ? void 0 : lastCaseUpdate.getTime());
  return /*#__PURE__*/_react.default.createElement("p", null, actions.read && /*#__PURE__*/_react.default.createElement("span", {
    css: iconWrapperCss
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "original",
    title: (_theCase$externalServ4 = theCase.externalService) === null || _theCase$externalServ4 === void 0 ? void 0 : _theCase$externalServ4.connectorName,
    type: (0, _utils.getConnectorIcon)(triggersActionsUi, lastPushedConnector === null || lastPushedConnector === void 0 ? void 0 : lastPushedConnector.actionTypeId),
    "data-test-subj": "cases-table-connector-icon"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": `case-table-column-external`,
    title: (_theCase$externalServ5 = theCase.externalService) === null || _theCase$externalServ5 === void 0 ? void 0 : _theCase$externalServ5.connectorName,
    href: (_theCase$externalServ6 = theCase.externalService) === null || _theCase$externalServ6 === void 0 ? void 0 : _theCase$externalServ6.externalUrl,
    target: "_blank",
    "aria-label": i18n.PUSH_LINK_ARIA((_theCase$externalServ7 = theCase.externalService) === null || _theCase$externalServ7 === void 0 ? void 0 : _theCase$externalServ7.connectorName)
  }, (_theCase$externalServ8 = theCase.externalService) === null || _theCase$externalServ8 === void 0 ? void 0 : _theCase$externalServ8.externalTitle), hasDataToPush ? renderStringField(i18n.REQUIRES_UPDATE, `case-table-column-external-requiresUpdate`) : renderStringField(i18n.UP_TO_DATE, `case-table-column-external-upToDate`));
};
exports.ExternalServiceColumn = ExternalServiceColumn;
ExternalServiceColumn.displayName = 'ExternalServiceColumn';