"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetTagsResponseRt = exports.GetReportersResponseRt = exports.GetRelatedCasesByAlertResponseRt = exports.GetCategoriesResponseRt = exports.CasesSearchRequestRt = exports.CasesPatchRequestRt = exports.CasesFindResponseRt = exports.CasesFindRequestSortFieldsRt = exports.CasesFindRequestSearchFieldsRt = exports.CasesFindRequestRt = exports.CasesDeleteRequestRt = exports.CasesByAlertIDRequestRt = exports.CasesBulkGetResponseRt = exports.CasesBulkGetRequestRt = exports.CaseResolveResponseRt = exports.CaseRequestCustomFieldsRt = exports.CasePushRequestParamsRt = exports.CasePostRequestRt = exports.CasePatchRequestRt = exports.BulkCreateCasesResponseRt = exports.BulkCreateCasesRequestRt = exports.AllTagsFindRequestRt = exports.AllReportersFindRequestRt = exports.AllCategoriesFindRequestRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _constants = require("../../../constants");
var _schema = require("../../../schema");
var _domain = require("../../domain");
var _v = require("../../domain/case/v1");
var _v2 = require("../../domain/connector/v1");
var _v3 = require("../../domain/user/v1");
var _v4 = require("../stats/v1");
var _v5 = require("../custom_field/v1");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CaseCustomFieldTextWithValidationRt = rt.strict({
  key: rt.string,
  type: _domain.CustomFieldTextTypeRt,
  value: rt.union([(0, _v5.CaseCustomFieldTextWithValidationValueRt)('value'), rt.null])
});
const CustomFieldRt = rt.union([CaseCustomFieldTextWithValidationRt, _domain.CaseCustomFieldToggleRt]);
const CaseRequestCustomFieldsRt = exports.CaseRequestCustomFieldsRt = (0, _schema.limitedArraySchema)({
  codec: CustomFieldRt,
  fieldName: 'customFields',
  min: 0,
  max: _constants.MAX_CUSTOM_FIELDS_PER_CASE
});

/**
 * Create case
 */
const CasePostRequestRt = exports.CasePostRequestRt = rt.intersection([rt.strict({
  /**
   * Description of the case
   */
  description: (0, _schema.limitedStringSchema)({
    fieldName: 'description',
    min: 1,
    max: _constants.MAX_DESCRIPTION_LENGTH
  }),
  /**
   * Identifiers for the case.
   */
  tags: (0, _schema.limitedArraySchema)({
    codec: (0, _schema.limitedStringSchema)({
      fieldName: 'tag',
      min: 1,
      max: _constants.MAX_LENGTH_PER_TAG
    }),
    fieldName: 'tags',
    min: 0,
    max: _constants.MAX_TAGS_PER_CASE
  }),
  /**
   * Title of the case
   */
  title: (0, _schema.limitedStringSchema)({
    fieldName: 'title',
    min: 1,
    max: _constants.MAX_TITLE_LENGTH
  }),
  /**
   * The external configuration for the case
   */
  connector: _v2.CaseConnectorRt,
  /**
   * Sync settings for alerts
   */
  settings: _v.CaseSettingsRt,
  /**
   * The owner here must match the string used when a plugin registers a feature with access to the cases plugin. The user
   * creating this case must also be granted access to that plugin's feature.
   */
  owner: rt.string
}), rt.exact(rt.partial({
  /**
   * The users assigned to the case
   */
  assignees: (0, _schema.limitedArraySchema)({
    codec: _v3.CaseUserProfileRt,
    fieldName: 'assignees',
    min: 0,
    max: _constants.MAX_ASSIGNEES_PER_CASE
  }),
  /**
   * The severity of the case. The severity is
   * default it to "low" if not provided.
   */
  severity: _v.CaseSeverityRt,
  /**
   * The category of the case.
   */
  category: rt.union([(0, _schema.limitedStringSchema)({
    fieldName: 'category',
    min: 1,
    max: _constants.MAX_CATEGORY_LENGTH
  }), rt.null]),
  /**
   * The list of custom field values of the case.
   */
  customFields: CaseRequestCustomFieldsRt
}))]);

/**
 * Bulk create cases
 */

const CaseCreateRequestWithOptionalId = rt.intersection([CasePostRequestRt, rt.exact(rt.partial({
  id: rt.string
}))]);
const BulkCreateCasesRequestRt = exports.BulkCreateCasesRequestRt = rt.strict({
  cases: rt.array(CaseCreateRequestWithOptionalId)
});
const BulkCreateCasesResponseRt = exports.BulkCreateCasesResponseRt = rt.strict({
  cases: rt.array(_v.CaseRt)
});

/**
 * Find cases
 */

const CasesFindRequestSearchFieldsRt = exports.CasesFindRequestSearchFieldsRt = rt.keyof({
  description: null,
  title: null
});
const CasesFindRequestSortFieldsRt = exports.CasesFindRequestSortFieldsRt = rt.keyof({
  title: null,
  category: null,
  createdAt: null,
  updatedAt: null,
  closedAt: null,
  status: null,
  severity: null
});
const CasesFindRequestRt = exports.CasesFindRequestRt = rt.intersection([rt.exact(rt.partial({
  /**
   * Tags to filter by
   */
  tags: rt.union([(0, _schema.limitedArraySchema)({
    codec: rt.string,
    fieldName: 'tags',
    min: 0,
    max: _constants.MAX_TAGS_FILTER_LENGTH
  }), rt.string]),
  /**
   * The status of the case (open, closed, in-progress)
   */
  status: rt.union([_v.CaseStatusRt, rt.array(_v.CaseStatusRt)]),
  /**
   * The severity of the case
   */
  severity: rt.union([_v.CaseSeverityRt, rt.array(_v.CaseSeverityRt)]),
  /**
   * The uids of the user profiles to filter by
   */
  assignees: rt.union([(0, _schema.limitedArraySchema)({
    codec: rt.string,
    fieldName: 'assignees',
    min: 0,
    max: _constants.MAX_ASSIGNEES_FILTER_LENGTH
  }), rt.string]),
  /**
   * The reporters to filter by
   */
  reporters: rt.union([(0, _schema.limitedArraySchema)({
    codec: rt.string,
    fieldName: 'reporters',
    min: 0,
    max: _constants.MAX_REPORTERS_FILTER_LENGTH
  }), rt.string]),
  /**
   * Operator to use for the `search` field
   */
  defaultSearchOperator: rt.union([rt.literal('AND'), rt.literal('OR')]),
  /**
   * A KQL date. If used all cases created after (gte) the from date will be returned
   */
  from: rt.string,
  /**
   * The page of objects to return
   */
  // page: rt.union([rt.number, NumberFromString]),
  /**
   * The number of objects to include in each page
   */
  // perPage: rt.union([rt.number, NumberFromString]),
  /**
   * An Elasticsearch simple_query_string
   */
  search: rt.string,
  /**
   * The fields to perform the simple_query_string parsed query against
   */
  searchFields: rt.union([rt.array(CasesFindRequestSearchFieldsRt), CasesFindRequestSearchFieldsRt]),
  /**
   * The field to use for sorting the found objects.
   *
   */
  sortField: CasesFindRequestSortFieldsRt,
  /**
   * The order to sort by
   */
  sortOrder: rt.union([rt.literal('desc'), rt.literal('asc')]),
  /**
   * A KQL date. If used all cases created before (lte) the to date will be returned.
   */
  to: rt.string,
  /**
   * The owner(s) to filter by. The user making the request must have privileges to retrieve cases of that
   * ownership or they will be ignored. If no owner is included, then all ownership types will be included in the response
   * that the user has access to.
   */

  owner: rt.union([rt.array(rt.string), rt.string]),
  /**
   * The category of the case.
   */
  category: rt.union([(0, _schema.limitedArraySchema)({
    codec: rt.string,
    fieldName: 'category',
    min: 0,
    max: _constants.MAX_CATEGORY_FILTER_LENGTH
  }), rt.string])
})), (0, _schema.paginationSchema)({
  maxPerPage: _constants.MAX_CASES_PER_PAGE
})]);
const CasesSearchRequestRt = exports.CasesSearchRequestRt = rt.intersection([rt.exact(rt.partial({
  /**
   * custom fields of the case
   */
  customFields: rt.record(rt.string, rt.array(rt.union([rt.string, rt.boolean, rt.number, rt.null])))
})), CasesFindRequestRt]);
const CasesFindResponseRt = exports.CasesFindResponseRt = rt.intersection([rt.strict({
  cases: rt.array(_v.CaseRt),
  page: rt.number,
  per_page: rt.number,
  total: rt.number
}), _v4.CasesStatusResponseRt]);

/**
 * Delete cases
 */

const CasesDeleteRequestRt = exports.CasesDeleteRequestRt = (0, _schema.limitedArraySchema)({
  codec: _schema.NonEmptyString,
  min: 1,
  max: _constants.MAX_DELETE_IDS_LENGTH,
  fieldName: 'ids'
});

/**
 * Resolve case
 */

const CaseResolveResponseRt = exports.CaseResolveResponseRt = rt.intersection([rt.strict({
  case: _v.CaseRt,
  outcome: rt.union([rt.literal('exactMatch'), rt.literal('aliasMatch'), rt.literal('conflict')])
}), rt.exact(rt.partial({
  alias_target_id: rt.string,
  alias_purpose: rt.union([rt.literal('savedObjectConversion'), rt.literal('savedObjectImport')])
}))]);

/**
 * Get cases
 */
const CasesBulkGetRequestRt = exports.CasesBulkGetRequestRt = rt.strict({
  ids: (0, _schema.limitedArraySchema)({
    codec: rt.string,
    min: 1,
    max: _constants.MAX_BULK_GET_CASES,
    fieldName: 'ids'
  })
});
const CasesBulkGetResponseRt = exports.CasesBulkGetResponseRt = rt.strict({
  cases: _v.CasesRt,
  errors: rt.array(rt.strict({
    error: rt.string,
    message: rt.string,
    status: rt.union([rt.undefined, rt.number]),
    caseId: rt.string
  }))
});

/**
 * Update cases
 */
const CasePatchRequestRt = exports.CasePatchRequestRt = rt.intersection([rt.exact(rt.partial({
  /**
   * The description of the case
   */
  description: (0, _schema.limitedStringSchema)({
    fieldName: 'description',
    min: 1,
    max: _constants.MAX_DESCRIPTION_LENGTH
  }),
  /**
   * The current status of the case (open, closed, in-progress)
   */
  status: _v.CaseStatusRt,
  /**
   * The identifying strings for filter a case
   */
  tags: (0, _schema.limitedArraySchema)({
    codec: (0, _schema.limitedStringSchema)({
      fieldName: 'tag',
      min: 1,
      max: _constants.MAX_LENGTH_PER_TAG
    }),
    min: 0,
    max: _constants.MAX_TAGS_PER_CASE,
    fieldName: 'tags'
  }),
  /**
   * The title of a case
   */
  title: (0, _schema.limitedStringSchema)({
    fieldName: 'title',
    min: 1,
    max: _constants.MAX_TITLE_LENGTH
  }),
  /**
   * The external system that the case can be synced with
   */
  connector: _v2.CaseConnectorRt,
  /**
   * The alert sync settings
   */
  settings: _v.CaseSettingsRt,
  /**
   * The plugin owner of the case
   */
  owner: rt.string,
  /**
   * The severity of the case
   */
  severity: _v.CaseSeverityRt,
  /**
   * The users assigned to this case
   */
  assignees: (0, _schema.limitedArraySchema)({
    codec: _v3.CaseUserProfileRt,
    fieldName: 'assignees',
    min: 0,
    max: _constants.MAX_ASSIGNEES_PER_CASE
  }),
  /**
   * The category of the case.
   */
  category: rt.union([(0, _schema.limitedStringSchema)({
    fieldName: 'category',
    min: 1,
    max: _constants.MAX_CATEGORY_LENGTH
  }), rt.null]),
  /**
   * Custom fields of the case
   */
  customFields: CaseRequestCustomFieldsRt
})),
/**
 * The saved object ID and version
 */
rt.strict({
  id: rt.string,
  version: rt.string
})]);
const CasesPatchRequestRt = exports.CasesPatchRequestRt = rt.strict({
  cases: (0, _schema.limitedArraySchema)({
    codec: CasePatchRequestRt,
    min: 1,
    max: _constants.MAX_CASES_TO_UPDATE,
    fieldName: 'cases'
  })
});

/**
 * Push case
 */

const CasePushRequestParamsRt = exports.CasePushRequestParamsRt = rt.strict({
  case_id: rt.string,
  connector_id: rt.string
});

/**
 * Taxonomies
 */

const AllTagsFindRequestRt = exports.AllTagsFindRequestRt = rt.exact(rt.partial({
  /**
   * The owner of the cases to retrieve the tags from. If no owner is provided the tags from all cases
   * that the user has access to will be returned.
   */
  owner: rt.union([rt.array(rt.string), rt.string])
}));
const AllCategoriesFindRequestRt = exports.AllCategoriesFindRequestRt = rt.exact(rt.partial({
  /**
   * The owner of the cases to retrieve the categories from. If no owner is provided the categories
   * from all cases that the user has access to will be returned.
   */
  owner: rt.union([rt.array(rt.string), rt.string])
}));
const AllReportersFindRequestRt = exports.AllReportersFindRequestRt = AllTagsFindRequestRt;
const GetTagsResponseRt = exports.GetTagsResponseRt = rt.array(rt.string);
const GetCategoriesResponseRt = exports.GetCategoriesResponseRt = rt.array(rt.string);
const GetReportersResponseRt = exports.GetReportersResponseRt = rt.array(_v3.UserRt);

/**
 * Alerts
 */

const CasesByAlertIDRequestRt = exports.CasesByAlertIDRequestRt = rt.exact(rt.partial({
  /**
   * The type of cases to retrieve given an alert ID. If no owner is provided, all cases
   * that the user has access to will be returned.
   */
  owner: rt.union([rt.array(rt.string), rt.string])
}));
const GetRelatedCasesByAlertResponseRt = exports.GetRelatedCasesByAlertResponseRt = rt.array(_v.RelatedCaseRt);