"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.STACK_APP_ID = exports.FEATURE_ID = exports.CASE_VIEW_TAB_PATH = exports.CASE_VIEW_PATH = exports.CASE_VIEW_COMMENT_PATH = exports.CASE_VIEW_ALERT_TABLE_PATH = exports.CASES_CREATE_PATH = exports.CASES_CONFIGURE_PATH = exports.APP_PATH = exports.APP_OWNER = exports.APP_ID = void 0;
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Application
 */

const APP_ID = exports.APP_ID = 'cases';
const FEATURE_ID = exports.FEATURE_ID = 'generalCases';
const APP_OWNER = exports.APP_OWNER = 'cases';
const APP_PATH = exports.APP_PATH = '/app/management/insightsAndAlerting/cases';
const CASES_CREATE_PATH = exports.CASES_CREATE_PATH = '/create';
const CASES_CONFIGURE_PATH = exports.CASES_CONFIGURE_PATH = '/configure';
const CASE_VIEW_PATH = exports.CASE_VIEW_PATH = '/:detailName';
const CASE_VIEW_COMMENT_PATH = exports.CASE_VIEW_COMMENT_PATH = `${CASE_VIEW_PATH}/:commentId`;
const CASE_VIEW_ALERT_TABLE_PATH = exports.CASE_VIEW_ALERT_TABLE_PATH = `${CASE_VIEW_PATH}/?tabId=${_types.CASE_VIEW_PAGE_TABS.ALERTS}`;
const CASE_VIEW_TAB_PATH = exports.CASE_VIEW_TAB_PATH = `${CASE_VIEW_PATH}/?tabId=:tabId`;

/**
 * The main Cases application is in the stack management under the
 * Alerts and Insights section. To do that, Cases registers to the management
 * application. This constant holds the application ID of the management plugin
 */
const STACK_APP_ID = exports.STACK_APP_ID = 'management';