"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TooltipContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _status = require("../status/status");
var _types = require("../status/types");
var _icon_with_count = require("./icon_with_count");
var _utils = require("./utils");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const TITLE_TRUNCATE_LENGTH = 35;
const DESCRIPTION_TRUNCATE_LENGTH = 80;
const USER_TRUNCATE_LENGTH = 15;
const CaseTooltipContentComponent = /*#__PURE__*/_react.default.memo(({
  title,
  description,
  status,
  totalComments,
  createdAt,
  createdBy
}) => {
  var _ref, _createdBy$username;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_status.Status, {
    status: status
  })), /*#__PURE__*/_react.default.createElement(_icon_with_count.IconWithCount, {
    count: totalComments,
    icon: 'editorComment'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "relative"
  }, /*#__PURE__*/_react.default.createElement("strong", null, (0, _utils.getTruncatedText)(title, TITLE_TRUNCATE_LENGTH)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "relative"
  }, (0, _utils.getTruncatedText)(description, DESCRIPTION_TRUNCATE_LENGTH))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "relative"
  }, status === _types.CaseStatuses.closed ? i18n.CLOSED : i18n.OPENED, ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
    value: createdAt
  }), ' ', createdBy.username || createdBy.fullName ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.BY, ' ', /*#__PURE__*/_react.default.createElement("strong", {
    "data-test-subj": "tooltip-username"
  }, (0, _utils.getTruncatedText)((_ref = (_createdBy$username = createdBy.username) !== null && _createdBy$username !== void 0 ? _createdBy$username : createdBy.fullName) !== null && _ref !== void 0 ? _ref : '', USER_TRUNCATE_LENGTH))) : null));
});
CaseTooltipContentComponent.displayName = 'TooltipContent';
const TooltipContent = exports.TooltipContent = /*#__PURE__*/(0, _react.memo)(CaseTooltipContentComponent);