"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.embeddableReducer = void 0;
var _interpreter = require("@kbn/interpreter");
var _reduxActions = require("redux-actions");
var _embeddable = require("../actions/embeddable");
var _elements = require("./elements");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error untyped local

const embeddableReducer = exports.embeddableReducer = (0, _reduxActions.handleActions)({
  [_embeddable.UpdateEmbeddableExpressionActionType]: (workpadState, {
    payload
  }) => {
    if (!payload) {
      return workpadState;
    }
    const {
      elementId,
      embeddableExpression
    } = payload;

    // Find the element
    const pageWithElement = workpadState.pages.find(page => {
      return page.elements.find(element => element.id === elementId) !== undefined;
    });
    if (!pageWithElement) {
      return workpadState;
    }
    const element = pageWithElement.elements.find(elem => elem.id === elementId);
    if (!element || element.expression === embeddableExpression) {
      return workpadState;
    }
    const existingAst = (0, _interpreter.fromExpression)(element.expression);
    const newAst = (0, _interpreter.fromExpression)(embeddableExpression);
    const searchForFunction = newAst.chain[0].function;

    // Find the first matching function in the existing ASt
    const existingAstFunction = existingAst.chain.find(f => f.function === searchForFunction);
    if (!existingAstFunction) {
      return workpadState;
    }
    existingAstFunction.arguments = newAst.chain[0].arguments;
    const updatedExpression = (0, _interpreter.toExpression)(existingAst);
    return (0, _elements.assignNodeProperties)(workpadState, pageWithElement.id, elementId, {
      expression: updatedExpression
    });
  }
}, {});