"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.notifyServiceFactory = void 0;
var _lodash = require("lodash");
var _format_msg = require("../../lib/format_msg");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getToast = (err, opts = {}) => {
  const errData = (0, _lodash.get)(err, 'response') || err;
  const errBody = (0, _lodash.get)(err, 'body', undefined);
  const errMsg = (0, _format_msg.formatMsg)(errBody !== undefined ? err : errData);
  const {
    title,
    ...rest
  } = opts;
  let text;
  if (title) {
    text = errMsg;
  }
  return {
    ...rest,
    title: title || errMsg,
    text
  };
};
const notifyServiceFactory = ({
  coreStart
}) => {
  const toasts = coreStart.notifications.toasts;
  return {
    /*
     * @param {(string | Object)} err: message or Error object
     * @param {Object} opts: option to override toast title or icon, see https://github.com/elastic/kibana/blob/main/src/legacy/ui/public/notify/toasts/TOAST_NOTIFICATIONS.md
     */
    error(err, opts) {
      toasts.addDanger(getToast(err, opts));
    },
    warning(err, opts) {
      toasts.addWarning(getToast(err, opts));
    },
    info(err, opts) {
      toasts.add(getToast(err, opts));
    },
    success(err, opts) {
      toasts.addSuccess(getToast(err, opts));
    }
  };
};
exports.notifyServiceFactory = notifyServiceFactory;