"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toFunctionFactory = toFunctionFactory;
var _interpreter = require("@kbn/interpreter");
var _i18n = require("../../i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function toFunctionFactory(initialize) {
  return function to() {
    const {
      help,
      args: argHelp
    } = (0, _i18n.getFunctionHelp)().to;
    const errors = (0, _i18n.getFunctionErrors)().to;
    return {
      name: 'to',
      aliases: [],
      help,
      args: {
        type: {
          types: ['string'],
          help: argHelp.type,
          aliases: ['_'],
          multi: true
        }
      },
      fn: (input, args) => {
        if (!args.type) {
          throw errors.missingType();
        }
        return (0, _interpreter.castProvider)(initialize.types)(input, args.type);
      }
    };
  };
}