"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddEmbeddableFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/saved-objects-finder-plugin/public");
var _services = require("../../services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getNoItemsText: () => _i18n.i18n.translate('xpack.canvas.embedObject.noMatchingObjectsMessage', {
    defaultMessage: 'No matching objects found.'
  }),
  getTitleText: () => _i18n.i18n.translate('xpack.canvas.embedObject.titleText', {
    defaultMessage: 'Add from library'
  })
};
const AddEmbeddableFlyout = ({
  onSelect,
  availableEmbeddables,
  onClose,
  isByValueEnabled
}) => {
  const embeddablesService = (0, _services.useEmbeddablesService)();
  const platformService = (0, _services.usePlatformService)();
  const {
    getEmbeddableFactories
  } = embeddablesService;
  const {
    getContentManagement,
    getUISettings
  } = platformService;
  const onAddPanel = (0, _react.useCallback)((id, savedObjectType) => {
    const embeddableFactories = getEmbeddableFactories();
    // Find the embeddable type from the saved object type
    const found = Array.from(embeddableFactories).find(embeddableFactory => {
      return Boolean(embeddableFactory.savedObjectMetaData && embeddableFactory.savedObjectMetaData.type === savedObjectType);
    });
    const foundEmbeddableType = found ? found.type : 'unknown';
    onSelect(id, foundEmbeddableType, isByValueEnabled);
  }, [isByValueEnabled, getEmbeddableFactories, onSelect]);
  const embeddableFactories = getEmbeddableFactories();
  const availableSavedObjects = Array.from(embeddableFactories).filter(factory => factory.type !== 'links' && (
  // Links panels only exist on Dashboards
  isByValueEnabled || availableEmbeddables.includes(factory.type))).map(factory => factory.savedObjectMetaData).filter(function (maybeSavedObjectMetaData) {
    return maybeSavedObjectMetaData !== undefined;
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: onClose,
    "data-test-subj": "dashboardAddPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, strings.getTitleText()))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_public.SavedObjectFinder, {
    onChoose: onAddPanel,
    savedObjectMetaData: availableSavedObjects,
    showFilter: true,
    noItemsMessage: strings.getNoItemsText(),
    services: {
      contentClient: getContentManagement().client,
      uiSettings: getUISettings()
    }
  })));
};
exports.AddEmbeddableFlyout = AddEmbeddableFlyout;