"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ZOOM_LEVELS = exports.WORKPAD_CANVAS_BUFFER = exports.VALID_IMAGE_TYPES = exports.TEMPLATE_TYPE = exports.SESSIONSTORAGE_LASTPATH = exports.MIN_ZOOM_LEVEL = exports.MAX_ZOOM_LEVEL = exports.LOCALSTORAGE_PREFIX = exports.LOCALSTORAGE_CLIPBOARD = exports.LAUNCHED_FULLSCREEN_AUTOPLAY = exports.LAUNCHED_FULLSCREEN = exports.INTERNAL_API_ROUTE = exports.FETCH_TIMEOUT = exports.ELEMENT_SHIFT_OFFSET = exports.ELEMENT_NUDGE_OFFSET = exports.DEFAULT_WORKPAD_CSS = exports.DEFAULT_GROUP_BY_FIELD = exports.DEFAULT_ELEMENT_CSS = exports.DATATABLE_COLUMN_TYPES = exports.CUSTOM_ELEMENT_TYPE = exports.CONTEXT_MENU_TOP_BORDER_CLASSNAME = exports.CANVAS_TYPE = exports.CANVAS_LAYOUT_STAGE_CONTENT_SELECTOR = exports.CANVAS_EMBEDDABLE_CLASSNAME = exports.CANVAS_APP = exports.ASSET_MAX_SIZE = exports.APP_ROUTE_WORKPAD = exports.APP_ROUTE = exports.API_ROUTE_WORKPAD_STRUCTURES = exports.API_ROUTE_WORKPAD_IMPORT = exports.API_ROUTE_WORKPAD_EXPORT = exports.API_ROUTE_WORKPAD_ASSETS = exports.API_ROUTE_WORKPAD = exports.API_ROUTE_TEMPLATES = exports.API_ROUTE_SHAREABLE_ZIP = exports.API_ROUTE_SHAREABLE_RUNTIME_DOWNLOAD = exports.API_ROUTE_SHAREABLE_RUNTIME = exports.API_ROUTE_SHAREABLE_BASE = exports.API_ROUTE_FUNCTIONS = exports.API_ROUTE_CUSTOM_ELEMENT = void 0;
var _constants_static = require("../../shareable_runtime/constants_static");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line @kbn/imports/no_boundary_crossing

const CANVAS_TYPE = exports.CANVAS_TYPE = 'canvas-workpad';
const CUSTOM_ELEMENT_TYPE = exports.CUSTOM_ELEMENT_TYPE = 'canvas-element';
const TEMPLATE_TYPE = exports.TEMPLATE_TYPE = `${CANVAS_TYPE}-template`;
const CANVAS_APP = exports.CANVAS_APP = 'canvas';
const APP_ROUTE = exports.APP_ROUTE = '/app/canvas';
const APP_ROUTE_WORKPAD = exports.APP_ROUTE_WORKPAD = `${APP_ROUTE}#/workpad`;
const INTERNAL_API_ROUTE = exports.INTERNAL_API_ROUTE = '/internal/canvas';
const API_ROUTE_WORKPAD = exports.API_ROUTE_WORKPAD = `${INTERNAL_API_ROUTE}/workpad`;
const API_ROUTE_WORKPAD_EXPORT = exports.API_ROUTE_WORKPAD_EXPORT = `${API_ROUTE_WORKPAD}/export`;
const API_ROUTE_WORKPAD_IMPORT = exports.API_ROUTE_WORKPAD_IMPORT = `${API_ROUTE_WORKPAD}/import`;
const API_ROUTE_WORKPAD_ASSETS = exports.API_ROUTE_WORKPAD_ASSETS = `${INTERNAL_API_ROUTE}/workpad-assets`;
const API_ROUTE_WORKPAD_STRUCTURES = exports.API_ROUTE_WORKPAD_STRUCTURES = `${INTERNAL_API_ROUTE}/workpad-structures`;
const API_ROUTE_CUSTOM_ELEMENT = exports.API_ROUTE_CUSTOM_ELEMENT = `${INTERNAL_API_ROUTE}/custom-element`;
const API_ROUTE_TEMPLATES = exports.API_ROUTE_TEMPLATES = `${INTERNAL_API_ROUTE}/templates`;
const LOCALSTORAGE_PREFIX = exports.LOCALSTORAGE_PREFIX = `kibana.canvas`;
const LOCALSTORAGE_CLIPBOARD = exports.LOCALSTORAGE_CLIPBOARD = `${LOCALSTORAGE_PREFIX}.clipboard`;
const SESSIONSTORAGE_LASTPATH = exports.SESSIONSTORAGE_LASTPATH = 'lastPath:canvas';
const FETCH_TIMEOUT = exports.FETCH_TIMEOUT = 30000; // 30 seconds
const DEFAULT_WORKPAD_CSS = exports.DEFAULT_WORKPAD_CSS = '.canvasPage {\n\n}';
const DEFAULT_ELEMENT_CSS = exports.DEFAULT_ELEMENT_CSS = '.canvasRenderEl{\n\n}';
const DEFAULT_GROUP_BY_FIELD = exports.DEFAULT_GROUP_BY_FIELD = 'filterGroup';
const VALID_IMAGE_TYPES = exports.VALID_IMAGE_TYPES = ['gif', 'jpeg', 'png', 'svg+xml'];
const ASSET_MAX_SIZE = exports.ASSET_MAX_SIZE = 25000;
const ELEMENT_SHIFT_OFFSET = exports.ELEMENT_SHIFT_OFFSET = 10;
const ELEMENT_NUDGE_OFFSET = exports.ELEMENT_NUDGE_OFFSET = 1;
const ZOOM_LEVELS = exports.ZOOM_LEVELS = [0.25, 0.33, 0.5, 0.67, 0.75, 1, 1.25, 1.5, 1.75, 2, 3, 4].sort();
const MIN_ZOOM_LEVEL = exports.MIN_ZOOM_LEVEL = ZOOM_LEVELS[0];
const MAX_ZOOM_LEVEL = exports.MAX_ZOOM_LEVEL = ZOOM_LEVELS[ZOOM_LEVELS.length - 1];
const WORKPAD_CANVAS_BUFFER = exports.WORKPAD_CANVAS_BUFFER = 32; // 32px padding around the workpad
const CANVAS_LAYOUT_STAGE_CONTENT_SELECTOR = exports.CANVAS_LAYOUT_STAGE_CONTENT_SELECTOR = `canvasLayout__stageContent`;
const DATATABLE_COLUMN_TYPES = exports.DATATABLE_COLUMN_TYPES = ['string', 'number', 'null', 'boolean', 'date'];
const LAUNCHED_FULLSCREEN = exports.LAUNCHED_FULLSCREEN = 'workpad-full-screen-launch';
const LAUNCHED_FULLSCREEN_AUTOPLAY = exports.LAUNCHED_FULLSCREEN_AUTOPLAY = 'workpad-full-screen-launch-with-autoplay';
const API_ROUTE_SHAREABLE_BASE = exports.API_ROUTE_SHAREABLE_BASE = '/public/canvas';
const API_ROUTE_SHAREABLE_ZIP = exports.API_ROUTE_SHAREABLE_ZIP = '/public/canvas/zip';
const API_ROUTE_SHAREABLE_RUNTIME = exports.API_ROUTE_SHAREABLE_RUNTIME = '/public/canvas/runtime';
const API_ROUTE_SHAREABLE_RUNTIME_DOWNLOAD = exports.API_ROUTE_SHAREABLE_RUNTIME_DOWNLOAD = `/public/canvas/${_constants_static.SHAREABLE_RUNTIME_NAME}.js`;
const CANVAS_EMBEDDABLE_CLASSNAME = exports.CANVAS_EMBEDDABLE_CLASSNAME = `canvasEmbeddable`;
const CONTEXT_MENU_TOP_BORDER_CLASSNAME = exports.CONTEXT_MENU_TOP_BORDER_CLASSNAME = 'canvasContextMenu--topBorder';
const API_ROUTE_FUNCTIONS = exports.API_ROUTE_FUNCTIONS = `${INTERNAL_API_ROUTE}/fns`;