"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.podsRoutes = podsRoutes;
var _ioTsUtils = require("@kbn/io-ts-utils");
var _types_api = require("../../../common/types_api");
var _debug_log = require("../../../common/debug_log");
var routePaths = _interopRequireWildcard(require("../../../common/constants_routes"));
var _utils = require("../utils");
var _validation_error = require("../../lib/validators/validation_error");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function podsRoutes({
  router,
  assetClient
}) {
  const validate = (0, _ioTsUtils.createRouteValidationFunction)(_types_api.getPodAssetsQueryOptionsRT);
  router.get({
    path: routePaths.GET_PODS,
    validate: {
      query: (q, res) => {
        const [invalidResponse, validatedFilters] = (0, _utils.validateStringAssetFilters)(q, res);
        if (invalidResponse) {
          return invalidResponse;
        }
        if (validatedFilters) {
          q.filters = validatedFilters;
        }
        return validate(q, res);
      }
    }
  }, async (context, req, res) => {
    const {
      from = 'now-24h',
      to = 'now',
      filters
    } = req.query || {};
    const {
      elasticsearchClient,
      savedObjectsClient
    } = await (0, _utils.getClientsFromContext)(context);
    try {
      const response = await assetClient.getPods({
        from,
        to,
        filters,
        elasticsearchClient,
        savedObjectsClient
      });
      return res.ok({
        body: response
      });
    } catch (error) {
      (0, _debug_log.debug)('Error while looking up POD asset records', error);
      if (error instanceof _validation_error.AssetsValidationError) {
        return res.customError({
          statusCode: error.statusCode,
          body: {
            message: `Error while looking up pod asset records - ${error.message}`
          }
        });
      }
      return res.customError({
        statusCode: 500,
        body: {
          message: 'Error while looking up pod asset records - ' + `${error}`
        }
      });
    }
  });
}