"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getContainers = getContainers;
var _parse_ean = require("../../parse_ean");
var _collectors = require("../../collectors");
var _validate_date_range = require("../../validators/validate_date_range");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getContainers(options) {
  var _options$filters, _options$filters2, _options$filters3, _options$filters4;
  (0, _validate_date_range.validateStringDateRange)(options.from, options.to);
  const metricsIndices = await options.metricsClient.getMetricIndices({
    savedObjectsClient: options.savedObjectsClient
  });
  const filters = [];
  if ((_options$filters = options.filters) !== null && _options$filters !== void 0 && _options$filters.ean) {
    const ean = Array.isArray(options.filters.ean) ? options.filters.ean[0] : options.filters.ean;
    const {
      kind,
      id
    } = (0, _parse_ean.parseEan)(ean);

    // if EAN filter isn't targeting a container asset, we don't need to do this query
    if (kind !== 'container') {
      return {
        containers: []
      };
    }
    filters.push({
      term: {
        'container.id': id
      }
    });
  }
  if ((_options$filters2 = options.filters) !== null && _options$filters2 !== void 0 && _options$filters2.id) {
    const fn = options.filters.id.includes('*') ? 'wildcard' : 'term';
    filters.push({
      [fn]: {
        'container.id': options.filters.id
      }
    });
  }
  if ((_options$filters3 = options.filters) !== null && _options$filters3 !== void 0 && _options$filters3['cloud.provider']) {
    filters.push({
      term: {
        'cloud.provider': options.filters['cloud.provider']
      }
    });
  }
  if ((_options$filters4 = options.filters) !== null && _options$filters4 !== void 0 && _options$filters4['cloud.region']) {
    filters.push({
      term: {
        'cloud.region': options.filters['cloud.region']
      }
    });
  }
  const {
    assets
  } = await (0, _collectors.collectContainers)({
    client: options.elasticsearchClient,
    from: options.from,
    to: options.to || 'now',
    filters,
    sourceIndices: {
      metrics: metricsIndices,
      logs: options.sourceIndices.logs
    }
  });
  return {
    containers: assets
  };
}