"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sizeRT = exports.relationRT = exports.getServiceAssetsResponseRT = exports.getServiceAssetsQueryOptionsRT = exports.getPodAssetsResponseRT = exports.getPodAssetsQueryOptionsRT = exports.getHostAssetsResponseRT = exports.getHostAssetsQueryOptionsRT = exports.getContainerAssetsResponseRT = exports.getContainerAssetsQueryOptionsRT = exports.getAssetsResponseRT = exports.getAssetsQueryOptionsRT = exports.cloudProviderNameRT = exports.assetTypeRT = exports.assetStatusRT = exports.assetRT = exports.assetKindRT = exports.assetFiltersSingleKindRT = exports.assetFiltersRT = exports.assetDateRT = exports.ECSDocumentRT = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _ioTsUtils = require("@kbn/io-ts-utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const assetTypeRT = exports.assetTypeRT = rt.keyof({
  'k8s.pod': null,
  'k8s.cluster': null,
  'k8s.node': null
});
const assetKindRT = exports.assetKindRT = rt.keyof({
  cluster: null,
  host: null,
  pod: null,
  container: null,
  service: null
});
const assetStatusRT = exports.assetStatusRT = rt.keyof({
  CREATING: null,
  ACTIVE: null,
  DELETING: null,
  FAILED: null,
  UPDATING: null,
  PENDING: null,
  UNKNOWN: null
});
// https://github.com/gcanti/io-ts/blob/master/index.md#union-of-string-literals
const cloudProviderNameRT = exports.cloudProviderNameRT = rt.keyof({
  aws: null,
  gcp: null,
  azure: null,
  other: null,
  unknown: null,
  none: null
});
const withTimestampRT = rt.type({
  '@timestamp': rt.string
});
const ECSDocumentRT = exports.ECSDocumentRT = rt.intersection([withTimestampRT, rt.partial({
  'kubernetes.namespace': rt.string,
  'kubernetes.pod.name': rt.string,
  'kubernetes.pod.uid': rt.string,
  'kubernetes.pod.start_time': rt.string,
  'kubernetes.node.name': rt.string,
  'kubernetes.node.start_time': rt.string,
  'orchestrator.api_version': rt.string,
  'orchestrator.namespace': rt.string,
  'orchestrator.organization': rt.string,
  'orchestrator.type': rt.string,
  'orchestrator.cluster.id': rt.string,
  'orchestrator.cluster.name': rt.string,
  'orchestrator.cluster.url': rt.string,
  'orchestrator.cluster.version': rt.string,
  'cloud.provider': cloudProviderNameRT,
  'cloud.instance.id': rt.string,
  'cloud.region': rt.string,
  'cloud.service.name': rt.string,
  'service.environment': rt.string
})]);
const assetRT = exports.assetRT = rt.intersection([ECSDocumentRT, rt.type({
  'asset.ean': rt.string,
  'asset.id': rt.string,
  'asset.kind': assetKindRT
}),
// mixed required and optional require separate hashes combined via intersection
// https://github.com/gcanti/io-ts/blob/master/index.md#mixing-required-and-optional-props
rt.partial({
  'asset.collection_version': rt.string,
  'asset.name': rt.string,
  'asset.type': assetTypeRT,
  'asset.status': assetStatusRT,
  'asset.parents': rt.union([rt.string, rt.array(rt.string)]),
  'asset.children': rt.union([rt.string, rt.array(rt.string)]),
  'asset.references': rt.union([rt.string, rt.array(rt.string)]),
  'asset.namespace': rt.string
})]);
const assetFiltersSingleKindRT = exports.assetFiltersSingleKindRT = rt.exact(rt.partial({
  type: rt.union([assetTypeRT, rt.array(assetTypeRT)]),
  ean: rt.union([rt.string, rt.array(rt.string)]),
  id: rt.string,
  parentEan: rt.string,
  ['cloud.provider']: rt.string,
  ['cloud.region']: rt.string,
  ['orchestrator.cluster.name']: rt.string
}));
const supportedKindRT = rt.union([rt.literal('host'), rt.literal('service')]);
const assetFiltersRT = exports.assetFiltersRT = rt.intersection([assetFiltersSingleKindRT, rt.partial({
  kind: rt.union([supportedKindRT, rt.array(supportedKindRT)])
})]);
const relationRT = exports.relationRT = rt.union([rt.literal('ancestors'), rt.literal('descendants'), rt.literal('references')]);
const sizeRT = exports.sizeRT = rt.union([(0, _ioTsUtils.inRangeFromStringRt)(1, 100), (0, _ioTsUtils.createLiteralValueFromUndefinedRT)(10)]);
const assetDateRT = exports.assetDateRT = rt.union([_ioTsUtils.dateRt, _ioTsUtils.datemathStringRt]);

/**
 * Hosts
 */
const getHostAssetsQueryOptionsRT = exports.getHostAssetsQueryOptionsRT = rt.intersection([rt.strict({
  from: assetDateRT
}), rt.partial({
  to: assetDateRT,
  size: sizeRT,
  stringFilters: rt.string,
  filters: assetFiltersSingleKindRT
})]);
const getHostAssetsResponseRT = exports.getHostAssetsResponseRT = rt.type({
  hosts: rt.array(assetRT)
});
/**
 * Containers
 */
const getContainerAssetsQueryOptionsRT = exports.getContainerAssetsQueryOptionsRT = rt.intersection([rt.strict({
  from: assetDateRT
}), rt.partial({
  to: assetDateRT,
  size: sizeRT,
  stringFilters: rt.string,
  filters: assetFiltersSingleKindRT
})]);
const getContainerAssetsResponseRT = exports.getContainerAssetsResponseRT = rt.type({
  containers: rt.array(assetRT)
});
/**
 * Services
 */
const getServiceAssetsQueryOptionsRT = exports.getServiceAssetsQueryOptionsRT = rt.intersection([rt.strict({
  from: assetDateRT
}), rt.partial({
  from: assetDateRT,
  to: assetDateRT,
  size: sizeRT,
  stringFilters: rt.string,
  filters: assetFiltersSingleKindRT
})]);
const getServiceAssetsResponseRT = exports.getServiceAssetsResponseRT = rt.type({
  services: rt.array(assetRT)
});
/**
 * Pods
 */
const getPodAssetsQueryOptionsRT = exports.getPodAssetsQueryOptionsRT = rt.intersection([rt.strict({
  from: assetDateRT
}), rt.partial({
  to: assetDateRT,
  size: sizeRT,
  stringFilters: rt.string,
  filters: assetFiltersSingleKindRT
})]);
const getPodAssetsResponseRT = exports.getPodAssetsResponseRT = rt.type({
  pods: rt.array(assetRT)
});
/**
 * Assets
 */
const getAssetsQueryOptionsRT = exports.getAssetsQueryOptionsRT = rt.intersection([rt.strict({
  from: assetDateRT
}), rt.partial({
  to: assetDateRT,
  size: sizeRT,
  stringFilters: rt.string,
  filters: assetFiltersRT
})]);
const getAssetsResponseRT = exports.getAssetsResponseRT = rt.type({
  assets: rt.array(assetRT)
});