"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GET_SERVICES = exports.GET_RELATED_ASSETS = exports.GET_PODS = exports.GET_HOSTS = exports.GET_CONTAINERS = exports.GET_ASSETS_DIFF = exports.GET_ASSETS = exports.ASSET_MANAGER_API_BASE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ASSET_MANAGER_API_BASE = exports.ASSET_MANAGER_API_BASE = '/api/asset-manager';
function base(path) {
  return `${ASSET_MANAGER_API_BASE}${path}`;
}
const GET_ASSETS = exports.GET_ASSETS = base('/assets');
const GET_RELATED_ASSETS = exports.GET_RELATED_ASSETS = base('/assets/related');
const GET_ASSETS_DIFF = exports.GET_ASSETS_DIFF = base('/assets/diff');
const GET_HOSTS = exports.GET_HOSTS = base('/assets/hosts');
const GET_SERVICES = exports.GET_SERVICES = base('/assets/services');
const GET_CONTAINERS = exports.GET_CONTAINERS = base('/assets/containers');
const GET_PODS = exports.GET_PODS = base('/assets/pods');