"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServiceHostNames = getServiceHostNames;
var _server = require("@kbn/observability-plugin/server");
var _apm = require("../../../common/es_fields/apm");
var _environment_query = require("../../../common/utils/environment_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getServiceHostNames({
  apmEventClient,
  serviceName,
  start,
  end,
  environment,
  documentType,
  rollupInterval
}) {
  var _response$aggregation;
  const response = await apmEventClient.search('get_service_host_names', {
    apm: {
      sources: [{
        documentType,
        rollupInterval
      }]
    },
    body: {
      track_total_hits: false,
      size: 0,
      query: {
        bool: {
          filter: [{
            term: {
              [_apm.SERVICE_NAME]: serviceName
            }
          }, ...(0, _server.rangeQuery)(start, end), ...(0, _environment_query.environmentQuery)(environment)]
        }
      },
      aggs: {
        hostNames: {
          terms: {
            field: _apm.HOST_HOSTNAME,
            size: 500
          }
        }
      }
    }
  });
  return ((_response$aggregation = response.aggregations) === null || _response$aggregation === void 0 ? void 0 : _response$aggregation.hostNames.buckets.map(bucket => bucket.key)) || [];
}