"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogCategories = getLogCategories;
exports.getShouldMatchOrNotExistFilter = getShouldMatchOrNotExistFilter;
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var _server = require("@kbn/observability-ai-assistant-plugin/server");
var _apm = require("../../../../common/es_fields/apm");
var _create_typed_es_client = require("../../../utils/create_typed_es_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getLogCategories({
  esClient,
  coreContext,
  arguments: args
}) {
  var _datemath$parse, _datemath$parse2, _categorizedLogsRes$a, _categorizedLogsRes$a2;
  const start = (_datemath$parse = _datemath.default.parse(args.start)) === null || _datemath$parse === void 0 ? void 0 : _datemath$parse.valueOf();
  const end = (_datemath$parse2 = _datemath.default.parse(args.end)) === null || _datemath$parse2 === void 0 ? void 0 : _datemath$parse2.valueOf();
  const keyValueFilters = getShouldMatchOrNotExistFilter([{
    field: _apm.SERVICE_NAME,
    value: args[_apm.SERVICE_NAME]
  }, {
    field: _apm.CONTAINER_ID,
    value: args[_apm.CONTAINER_ID]
  }, {
    field: _apm.HOST_NAME,
    value: args[_apm.HOST_NAME]
  }, {
    field: _apm.KUBERNETES_POD_NAME,
    value: args[_apm.KUBERNETES_POD_NAME]
  }]);
  const index = await coreContext.uiSettings.client.get(_server.aiAssistantLogsIndexPattern);
  const search = (0, _create_typed_es_client.getTypedSearch)(esClient);
  const query = {
    bool: {
      filter: [...keyValueFilters, {
        exists: {
          field: 'message'
        }
      }, {
        range: {
          '@timestamp': {
            gte: start,
            lte: end
          }
        }
      }]
    }
  };
  const hitCountRes = await search({
    index,
    size: 0,
    track_total_hits: true,
    query
  });
  const totalDocCount = hitCountRes.hits.total.value;
  const rawSamplingProbability = Math.min(100_000 / totalDocCount, 1);
  const samplingProbability = rawSamplingProbability < 0.5 ? rawSamplingProbability : 1;
  const categorizedLogsRes = await search({
    index,
    size: 0,
    track_total_hits: 0,
    query,
    aggs: {
      sampling: {
        random_sampler: {
          probability: samplingProbability
        },
        aggs: {
          categories: {
            categorize_text: {
              field: 'message',
              size: 500
            },
            aggs: {
              sample: {
                top_hits: {
                  sort: {
                    '@timestamp': 'desc'
                  },
                  size: 1,
                  _source: ['message']
                }
              }
            }
          }
        }
      }
    }
  });
  return (_categorizedLogsRes$a = categorizedLogsRes.aggregations) === null || _categorizedLogsRes$a === void 0 ? void 0 : (_categorizedLogsRes$a2 = _categorizedLogsRes$a.sampling.categories) === null || _categorizedLogsRes$a2 === void 0 ? void 0 : _categorizedLogsRes$a2.buckets.map(({
    doc_count: docCount,
    key,
    sample
  }) => {
    const sampleMessage = sample.hits.hits[0]._source.message;
    return {
      errorCategory: key,
      docCount,
      sampleMessage
    };
  });
}

// field/value pairs should match, or the field should not exist
function getShouldMatchOrNotExistFilter(keyValuePairs) {
  return keyValuePairs.filter(({
    value
  }) => value).map(({
    field,
    value
  }) => {
    return {
      bool: {
        should: [{
          bool: {
            filter: [{
              term: {
                [field]: value
              }
            }]
          }
        }, {
          bool: {
            must_not: {
              bool: {
                filter: [{
                  exists: {
                    field
                  }
                }]
              }
            }
          }
        }],
        minimum_should_match: 1
      }
    };
  });
}