"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApmServiceSummary = getApmServiceSummary;
exports.serviceSummaryRouteRt = void 0;
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var _server = require("@kbn/observability-plugin/server");
var _technical_rule_data_field_names = require("@kbn/rule-registry-plugin/common/technical_rule_data_field_names");
var t = _interopRequireWildcard(require("io-ts"));
var _environment_filter_values = require("../../../../common/environment_filter_values");
var _apm = require("../../../../common/es_fields/apm");
var _environment_query = require("../../../../common/utils/environment_query");
var _term_query = require("../../../../common/utils/term_query");
var _get_environments = require("../../environments/get_environments");
var _annotations = require("../../services/annotations");
var _get_service_metadata_details = require("../../services/get_service_metadata_details");
var _get_anomalies = require("./get_anomalies");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const serviceSummaryRouteRt = exports.serviceSummaryRouteRt = t.intersection([t.type({
  'service.name': t.string,
  start: t.string,
  end: t.string
}), t.partial({
  'service.environment': t.string,
  'transaction.type': t.string
})]);
async function getApmServiceSummary({
  arguments: args,
  apmEventClient,
  mlClient,
  esClient,
  annotationsClient,
  apmAlertsClient,
  logger
}) {
  var _datemath$parse, _datemath$parse2, _metadataDetails$serv, _metadataDetails$serv2, _metadataDetails$serv3, _metadataDetails$serv4, _metadataDetails$cont, _metadataDetails$cont2;
  const start = (_datemath$parse = _datemath.default.parse(args.start)) === null || _datemath$parse === void 0 ? void 0 : _datemath$parse.valueOf();
  const end = (_datemath$parse2 = _datemath.default.parse(args.end)) === null || _datemath$parse2 === void 0 ? void 0 : _datemath$parse2.valueOf();
  const serviceName = args['service.name'];
  const environment = args['service.environment'] || _environment_filter_values.ENVIRONMENT_ALL.value;
  const transactionType = args['transaction.type'];
  const [environments, metadataDetails, anomalies, annotations, alerts] = await Promise.all([environment === _environment_filter_values.ENVIRONMENT_ALL.value ? (0, _get_environments.getEnvironments)({
    apmEventClient,
    start,
    end,
    size: 10,
    serviceName,
    searchAggregatedTransactions: true
  }) : Promise.resolve([environment]), (0, _get_service_metadata_details.getServiceMetadataDetails)({
    apmEventClient,
    start,
    end,
    serviceName,
    environment
  }), (0, _get_anomalies.getAnomalies)({
    serviceName,
    start,
    end,
    environment: args['service.environment'],
    mlClient,
    logger,
    transactionType
  }).catch(error => {
    logger.error('Failed to get anomalies');
    logger.error(error);
    return {
      error
    };
  }), (0, _annotations.getServiceAnnotations)({
    apmEventClient,
    start,
    end,
    searchAggregatedTransactions: true,
    client: esClient,
    annotationsClient,
    environment,
    logger,
    serviceName
  }), apmAlertsClient.search({
    size: 100,
    track_total_hits: false,
    query: {
      bool: {
        filter: [...(0, _term_query.termQuery)(_technical_rule_data_field_names.ALERT_RULE_PRODUCER, 'apm'), ...(0, _term_query.termQuery)(_technical_rule_data_field_names.ALERT_STATUS, _technical_rule_data_field_names.ALERT_STATUS_ACTIVE), ...(0, _server.rangeQuery)(start, end), ...(0, _term_query.termQuery)(_apm.SERVICE_NAME, serviceName), ...(0, _environment_query.environmentQuery)(environment)]
      }
    }
  })]);
  return {
    'service.name': serviceName,
    'service.environment': environments,
    'agent.name': (_metadataDetails$serv = metadataDetails.service) === null || _metadataDetails$serv === void 0 ? void 0 : _metadataDetails$serv.agent.name,
    'service.version': (_metadataDetails$serv2 = metadataDetails.service) === null || _metadataDetails$serv2 === void 0 ? void 0 : _metadataDetails$serv2.versions,
    'language.name': (_metadataDetails$serv3 = metadataDetails.service) === null || _metadataDetails$serv3 === void 0 ? void 0 : _metadataDetails$serv3.agent.name,
    'service.framework': (_metadataDetails$serv4 = metadataDetails.service) === null || _metadataDetails$serv4 === void 0 ? void 0 : _metadataDetails$serv4.framework,
    instances: (_metadataDetails$cont = (_metadataDetails$cont2 = metadataDetails.container) === null || _metadataDetails$cont2 === void 0 ? void 0 : _metadataDetails$cont2.totalNumberInstances) !== null && _metadataDetails$cont !== void 0 ? _metadataDetails$cont : 1,
    anomalies,
    alerts: alerts.hits.hits.map(alert => {
      var _alert$_source, _alert$_source2;
      return {
        type: (_alert$_source = alert._source) === null || _alert$_source === void 0 ? void 0 : _alert$_source['kibana.alert.rule.type'],
        started: new Date((_alert$_source2 = alert._source) === null || _alert$_source2 === void 0 ? void 0 : _alert$_source2['kibana.alert.start']).toISOString()
      };
    }),
    deployments: annotations.annotations.map(annotation => ({
      '@timestamp': new Date(annotation['@timestamp']).toISOString()
    }))
  };
}