"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApmServiceList = getApmServiceList;
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var _environment_filter_values = require("../../../../common/environment_filter_values");
var _rollup = require("../../../../common/rollup");
var _document_type = require("../../../../common/document_type");
var _service_health_status = require("../../../../common/service_health_status");
var _get_services_items = require("../../services/get_services/get_services_items");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getApmServiceList({
  arguments: args,
  apmEventClient,
  mlClient,
  apmAlertsClient,
  logger,
  randomSampler
}) {
  var _datemath$parse, _datemath$parse2;
  const {
    healthStatus
  } = args;
  const start = (_datemath$parse = _datemath.default.parse(args.start)) === null || _datemath$parse === void 0 ? void 0 : _datemath$parse.valueOf();
  const end = (_datemath$parse2 = _datemath.default.parse(args.end)) === null || _datemath$parse2 === void 0 ? void 0 : _datemath$parse2.valueOf();
  const serviceItems = await (0, _get_services_items.getServicesItems)({
    apmAlertsClient,
    apmEventClient,
    documentType: _document_type.ApmDocumentType.TransactionMetric,
    start,
    end,
    environment: args['service.environment'] || _environment_filter_values.ENVIRONMENT_ALL.value,
    kuery: '',
    logger,
    randomSampler,
    rollupInterval: _rollup.RollupInterval.OneMinute,
    serviceGroup: null,
    mlClient,
    useDurationSummary: false
  });
  let mappedItems = serviceItems.items.map(item => {
    var _item$alertsCount, _item$healthStatus;
    return {
      'service.name': item.serviceName,
      'agent.name': item.agentName,
      alertsCount: (_item$alertsCount = item.alertsCount) !== null && _item$alertsCount !== void 0 ? _item$alertsCount : 0,
      healthStatus: (_item$healthStatus = item.healthStatus) !== null && _item$healthStatus !== void 0 ? _item$healthStatus : _service_health_status.ServiceHealthStatus.unknown,
      'service.environment': item.environments,
      'transaction.type': item.transactionType
    };
  });
  if (healthStatus && healthStatus.length) {
    mappedItems = mappedItems.filter(item => healthStatus.includes(item.healthStatus));
  }
  return mappedItems;
}