"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStateDebounced = useStateDebounced;
var _lodash = require("lodash");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useStateDebounced(initialValue, debounceDelay = 300) {
  const [debouncedValue, setValue] = (0, _react.useState)(initialValue);

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const setValueDebounced = (0, _react.useCallback)((0, _lodash.debounce)(setValue, debounceDelay), [setValue, debounceDelay]);
  return [debouncedValue, setValueDebounced];
}