"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSearchServiceDestinationMetrics = useSearchServiceDestinationMetrics;
var _use_fetcher = require("../../hooks/use_fetcher");
var _use_time_range_metadata_context = require("./use_time_range_metadata_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useSearchServiceDestinationMetrics({
  start,
  end,
  kuery
}) {
  var _data$isUsingServiceD;
  const {
    status,
    data
  } = (0, _use_time_range_metadata_context.useTimeRangeMetadata)({
    start,
    end,
    kuery
  });
  return {
    isTimeRangeMetadataLoading: status === _use_fetcher.FETCH_STATUS.LOADING,
    searchServiceDestinationMetrics: (_data$isUsingServiceD = data === null || data === void 0 ? void 0 : data.isUsingServiceDestinationMetrics) !== null && _data$isUsingServiceD !== void 0 ? _data$isUsingServiceD : true
  };
}