"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mobileServiceDetailRoute = void 0;
exports.page = page;
var _i18n = require("@kbn/i18n");
var _ioTsUtils = require("@kbn/io-ts-utils");
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var t = _interopRequireWildcard(require("io-ts"));
var _react = _interopRequireDefault(require("react"));
var _comparison_rt = require("../../../../common/comparison_rt");
var _environment_filter_values = require("../../../../common/environment_filter_values");
var _environment_rt = require("../../../../common/environment_rt");
var _latency_aggregation_types = require("../../../../common/latency_aggregation_types");
var _alerts_overview = require("../../app/alerts_overview");
var _service_map = require("../../app/service_map");
var _mobile_service_template = require("../templates/mobile_service_template");
var _service_overview = require("../../app/mobile/service_overview");
var _transaction_overview = require("../../app/mobile/transaction_overview");
var _transaction_details = require("../../app/transaction_details");
var _redirect_to_default_service_route_view = require("../service_detail/redirect_to_default_service_route_view");
var _time_range_metadata_context = require("../../../context/time_range_metadata/time_range_metadata_context");
var _error_group_details = require("../../app/mobile/errors_and_crashes_group_details/error_group_details");
var _crash_group_details = require("../../app/mobile/errors_and_crashes_group_details/crash_group_details");
var _errors_and_crashes_overview = require("../../app/mobile/errors_and_crashes_overview");
var _service_dependencies = require("../../app/service_dependencies");
var _service_dashboards = require("../../app/service_dashboards");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function page({
  title,
  tabKey,
  element,
  searchBarOptions
}) {
  return {
    element: /*#__PURE__*/_react.default.createElement(_mobile_service_template.MobileServiceTemplate, {
      title: title,
      selectedTabKey: tabKey,
      searchBarOptions: searchBarOptions
    }, element)
  };
}
const mobileServiceDetailRoute = exports.mobileServiceDetailRoute = {
  '/mobile-services/{serviceName}': {
    element: /*#__PURE__*/_react.default.createElement(_time_range_metadata_context.ApmTimeRangeMetadataContextProvider, null, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, null)),
    params: t.intersection([t.type({
      path: t.type({
        serviceName: t.string
      })
    }), t.type({
      query: t.intersection([_environment_rt.environmentRt, t.type({
        rangeFrom: t.string,
        rangeTo: t.string,
        kuery: t.string,
        serviceGroup: t.string,
        comparisonEnabled: _ioTsUtils.toBooleanRt
      }), t.partial({
        latencyAggregationType: t.string,
        transactionType: t.string,
        refreshPaused: t.union([t.literal('true'), t.literal('false')]),
        refreshInterval: t.string
      }), _comparison_rt.offsetRt])
    })]),
    defaults: {
      query: {
        kuery: '',
        environment: _environment_filter_values.ENVIRONMENT_ALL.value,
        serviceGroup: '',
        latencyAggregationType: _latency_aggregation_types.LatencyAggregationType.avg
      }
    },
    children: {
      '/mobile-services/{serviceName}/overview': {
        ...page({
          element: /*#__PURE__*/_react.default.createElement(_service_overview.MobileServiceOverview, null),
          tabKey: 'overview',
          title: _i18n.i18n.translate('xpack.apm.views.overview.title', {
            defaultMessage: 'Overview'
          }),
          searchBarOptions: {
            showTransactionTypeSelector: true,
            showTimeComparison: true,
            showMobileFilters: true
          }
        }),
        params: t.partial({
          query: t.partial({
            page: _ioTsUtils.toNumberRt,
            pageSize: _ioTsUtils.toNumberRt,
            sortField: t.string,
            sortDirection: t.union([t.literal('asc'), t.literal('desc')]),
            device: t.string,
            osVersion: t.string,
            appVersion: t.string,
            netConnectionType: t.string
          })
        })
      },
      '/mobile-services/{serviceName}/transactions': {
        ...page({
          tabKey: 'transactions',
          title: _i18n.i18n.translate('xpack.apm.views.transactions.title', {
            defaultMessage: 'Transactions'
          }),
          element: /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, null),
          searchBarOptions: {
            showTransactionTypeSelector: true,
            showTimeComparison: true,
            showMobileFilters: true
          }
        }),
        params: t.partial({
          query: t.partial({
            page: _ioTsUtils.toNumberRt,
            pageSize: _ioTsUtils.toNumberRt,
            sortField: t.string,
            sortDirection: t.union([t.literal('asc'), t.literal('desc')]),
            device: t.string,
            osVersion: t.string,
            appVersion: t.string,
            netConnectionType: t.string,
            mobileSelectedTab: t.string
          })
        }),
        children: {
          '/mobile-services/{serviceName}/transactions/view': {
            element: /*#__PURE__*/_react.default.createElement(_transaction_details.TransactionDetails, null),
            params: t.type({
              query: t.intersection([t.type({
                transactionName: t.string,
                comparisonEnabled: _ioTsUtils.toBooleanRt,
                showCriticalPath: _ioTsUtils.toBooleanRt
              }), t.partial({
                traceId: t.string,
                transactionId: t.string,
                flyoutDetailTab: t.string
              }), _comparison_rt.offsetRt])
            }),
            defaults: {
              query: {
                showCriticalPath: ''
              }
            }
          },
          '/mobile-services/{serviceName}/transactions': {
            element: /*#__PURE__*/_react.default.createElement(_transaction_overview.MobileTransactionOverview, null)
          }
        }
      },
      '/mobile-services/{serviceName}/errors-and-crashes': {
        ...page({
          tabKey: 'errors-and-crashes',
          title: _i18n.i18n.translate('xpack.apm.views.errorsAndCrashes.title', {
            defaultMessage: 'Errors & Crashes'
          }),
          element: /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, null),
          searchBarOptions: {
            showTimeComparison: true,
            showMobileFilters: true
          }
        }),
        params: t.partial({
          query: t.partial({
            page: _ioTsUtils.toNumberRt,
            pageSize: _ioTsUtils.toNumberRt,
            sortField: t.string,
            sortDirection: t.union([t.literal('asc'), t.literal('desc')]),
            mobileErrorTabId: t.string,
            device: t.string,
            osVersion: t.string,
            appVersion: t.string,
            netConnectionType: t.string
          })
        }),
        children: {
          '/mobile-services/{serviceName}/errors-and-crashes/errors/{groupId}': {
            element: /*#__PURE__*/_react.default.createElement(_error_group_details.ErrorGroupDetails, null),
            params: t.type({
              path: t.type({
                groupId: t.string
              }),
              query: t.partial({
                errorId: t.string
              })
            })
          },
          '/mobile-services/{serviceName}/errors-and-crashes/': {
            element: /*#__PURE__*/_react.default.createElement(_errors_and_crashes_overview.MobileErrorCrashesOverview, null)
          },
          '/mobile-services/{serviceName}/errors-and-crashes/crashes/{groupId}': {
            element: /*#__PURE__*/_react.default.createElement(_crash_group_details.CrashGroupDetails, null),
            params: t.type({
              path: t.type({
                groupId: t.string
              }),
              query: t.partial({
                errorId: t.string
              })
            })
          }
        }
      },
      '/mobile-services/{serviceName}/dependencies': page({
        element: /*#__PURE__*/_react.default.createElement(_service_dependencies.ServiceDependencies, null),
        tabKey: 'dependencies',
        title: _i18n.i18n.translate('xpack.apm.views.dependencies.title', {
          defaultMessage: 'Dependencies'
        }),
        searchBarOptions: {
          showTimeComparison: true
        }
      }),
      '/mobile-services/{serviceName}/service-map': page({
        tabKey: 'service-map',
        title: _i18n.i18n.translate('xpack.apm.views.serviceMap.title', {
          defaultMessage: 'Service Map'
        }),
        element: /*#__PURE__*/_react.default.createElement(_service_map.ServiceMapServiceDetail, null),
        searchBarOptions: {
          hidden: true
        }
      }),
      '/mobile-services/{serviceName}/alerts': {
        ...page({
          tabKey: 'alerts',
          title: _i18n.i18n.translate('xpack.apm.views.alerts.title', {
            defaultMessage: 'Alerts'
          }),
          element: /*#__PURE__*/_react.default.createElement(_alerts_overview.AlertsOverview, null),
          searchBarOptions: {
            hidden: true
          }
        }),
        params: t.partial({
          query: t.partial({
            alertStatus: t.string
          })
        })
      },
      '/mobile-services/{serviceName}/dashboards': {
        ...page({
          tabKey: 'dashboards',
          title: _i18n.i18n.translate('xpack.apm.views.dashboard.title', {
            defaultMessage: 'Dashboards'
          }),
          element: /*#__PURE__*/_react.default.createElement(_service_dashboards.ServiceDashboards, null)
        }),
        params: t.partial({
          query: t.partial({
            dashboardId: t.string
          })
        })
      },
      '/mobile-services/{serviceName}/': {
        element: /*#__PURE__*/_react.default.createElement(_redirect_to_default_service_route_view.RedirectToDefaultServiceRouteView, null)
      }
    }
  }
};