"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Labs = Labs;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _labs_flyout = require("./labs_flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Labs() {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const trackApmEvent = (0, _public.useUiTracker)({
    app: 'apm'
  });
  (0, _react.useEffect)(() => {
    if (isOpen) {
      trackApmEvent({
        metric: 'labs_open'
      });
    }
  }, [isOpen, trackApmEvent]);
  function toggleFlyoutVisibility() {
    setIsOpen(state => !state);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "apmLabsLabsButton",
    color: "text",
    onClick: toggleFlyoutVisibility
  }, _i18n.i18n.translate('xpack.apm.labs', {
    defaultMessage: 'Labs'
  })), isOpen && /*#__PURE__*/_react.default.createElement(_labs_flyout.LabsFlyout, {
    onClose: toggleFlyoutVisibility
  }));
}