"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentInstructionsAccordion = AgentInstructionsAccordion;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxMarkdown = require("@kbn/shared-ux-markdown");
var _customIcons = require("@kbn/custom-icons");
var _agent_config_instructions = require("../../../tutorial/config_agent/agent_config_instructions");
var _render_mustache = require("./render_mustache");
var _technical_preview_badge = require("../../shared/technical_preview_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AccordionButtonContent({
  agentName,
  title
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_customIcons.AgentIcon, {
    size: "xl",
    agentName: agentName
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.apm.fleet_integration.settings.apmAgent.description', {
    defaultMessage: 'Configure instrumentation for {title} applications.',
    values: {
      title
    }
  })))))));
}
function InstructionsContent({
  markdown
}) {
  return /*#__PURE__*/_react.default.createElement(_sharedUxMarkdown.Markdown, {
    className: "euiText",
    readOnly: true
  }, markdown);
}
const StyledEuiAccordion = (0, _styledComponents.default)(_eui.EuiAccordion)`
  // This is an alternative fix suggested by the EUI team to fix drag elements inside EuiAccordion
  // This Issue tracks the fix on the Eui side https://github.com/elastic/eui/issues/3548#issuecomment-639041283
  .euiAccordion__childWrapper {
    transform: none;
  }
`;
function AgentInstructionsAccordion({
  policy,
  newPolicy,
  onChange,
  agentName,
  title,
  createAgentInstructions,
  variantId,
  AgentRuntimeAttachment
}) {
  var _newPolicy$inputs, _newPolicy$inputs$;
  const docLinks = (0, _public.useKibana)().services.docLinks;
  const vars = newPolicy === null || newPolicy === void 0 ? void 0 : (_newPolicy$inputs = newPolicy.inputs) === null || _newPolicy$inputs === void 0 ? void 0 : (_newPolicy$inputs$ = _newPolicy$inputs[0]) === null || _newPolicy$inputs$ === void 0 ? void 0 : _newPolicy$inputs$.vars;
  const apmServerUrl = vars === null || vars === void 0 ? void 0 : vars.url.value;
  const secretToken = vars === null || vars === void 0 ? void 0 : vars.secret_token.value;
  const steps = createAgentInstructions(apmServerUrl, secretToken);
  const stepsElements = steps.map(({
    title: stepTitle,
    textPre,
    textPost,
    customComponentName,
    commands
  }, index) => {
    const commandBlock = commands ? (0, _render_mustache.renderMustache)({
      text: commands,
      docLinks
    }) : '';
    return /*#__PURE__*/_react.default.createElement("section", {
      key: index
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, stepTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s"
    }, textPre && /*#__PURE__*/_react.default.createElement(InstructionsContent, {
      markdown: (0, _render_mustache.renderMustache)({
        text: textPre,
        docLinks
      })
    }), commandBlock && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      isCopyable: true,
      language: "bash"
    }, commandBlock)), customComponentName === 'TutorialConfigAgent' && /*#__PURE__*/_react.default.createElement(_agent_config_instructions.AgentConfigInstructions, {
      variantId: variantId,
      apmServerUrl: apmServerUrl,
      secretToken: secretToken
    }), customComponentName === 'TutorialConfigAgentRumScript' && /*#__PURE__*/_react.default.createElement(_agent_config_instructions.AgentConfigInstructions, {
      variantId: "js_script",
      apmServerUrl: apmServerUrl,
      secretToken: secretToken
    }), textPost && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(InstructionsContent, {
      markdown: (0, _render_mustache.renderMustache)({
        text: textPost,
        docLinks
      })
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
  });
  const manualInstrumentationContent = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), stepsElements);
  return /*#__PURE__*/_react.default.createElement(StyledEuiAccordion, {
    id: agentName,
    buttonContent: /*#__PURE__*/_react.default.createElement(AccordionButtonContent, {
      agentName: agentName,
      title: title
    })
  }, AgentRuntimeAttachment ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: [{
      id: 'manual-instrumentation',
      name: _i18n.i18n.translate('xpack.apm.fleetIntegration.apmAgent.runtimeAttachment.manualInstrumentation', {
        defaultMessage: 'Manual instrumentation'
      }),
      content: manualInstrumentationContent
    }, {
      id: 'auto-attachment',
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "flexStart",
        alignItems: "baseline",
        gutterSize: "s"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, _i18n.i18n.translate('xpack.apm.fleetIntegration.apmAgent.runtimeAttachment.autoAttachment', {
        defaultMessage: 'Auto-Attachment'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, null))),
      content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(AgentRuntimeAttachment, {
        policy: policy,
        newPolicy: newPolicy,
        onChange: onChange
      }))
    }]
  })) : manualInstrumentationContent);
}