"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallWithSummary = WaterfallWithSummary;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _transaction_summary = require("../../../shared/summary/transaction_summary");
var _transaction_action_menu = require("../../../shared/transaction_action_menu/transaction_action_menu");
var _maybe_view_trace_link = require("./maybe_view_trace_link");
var _transaction_tabs = require("./transaction_tabs");
var _use_fetcher = require("../../../../hooks/use_fetcher");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function WaterfallWithSummary({
  waterfallFetchResult,
  traceSamples,
  traceSamplesFetchStatus,
  environment,
  onSampleClick,
  onTabClick,
  serviceName,
  waterfallItemId,
  detailTab,
  showCriticalPath,
  onShowCriticalPathChange,
  selectedSample
}) {
  var _waterfallFetchResult;
  const [sampleActivePage, setSampleActivePage] = (0, _react.useState)(0);
  const isControlled = selectedSample !== undefined;
  const isLoading = waterfallFetchResult.status === _use_fetcher.FETCH_STATUS.LOADING || traceSamplesFetchStatus === _use_fetcher.FETCH_STATUS.LOADING;
  // When traceId is not present, call to waterfallFetchResult will not be initiated
  const isSucceded = (waterfallFetchResult.status === _use_fetcher.FETCH_STATUS.SUCCESS || waterfallFetchResult.status === _use_fetcher.FETCH_STATUS.NOT_INITIATED) && traceSamplesFetchStatus === _use_fetcher.FETCH_STATUS.SUCCESS;
  (0, _react.useEffect)(() => {
    if (!isControlled) {
      setSampleActivePage(0);
    }
  }, [traceSamples, isControlled]);
  const goToSample = index => {
    const sample = traceSamples[index];
    if (!isControlled) {
      setSampleActivePage(index);
    }
    onSampleClick(sample);
  };
  const samplePageIndex = isControlled ? selectedSample ? traceSamples === null || traceSamples === void 0 ? void 0 : traceSamples.indexOf(selectedSample) : 0 : sampleActivePage;
  const {
    entryTransaction
  } = waterfallFetchResult.waterfall;
  if (!entryTransaction && (traceSamples === null || traceSamples === void 0 ? void 0 : traceSamples.length) === 0 && isSucceded) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("div", null, _i18n.i18n.translate('xpack.apm.transactionDetails.traceNotFound', {
        defaultMessage: 'The selected trace cannot be found'
      })),
      "data-test-subj": "apmNoTraceFound",
      titleSize: "s"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.apm.transactionDetails.traceSampleTitle', {
    defaultMessage: 'Trace sample'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, !!(traceSamples !== null && traceSamples !== void 0 && traceSamples.length) && /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    pageCount: traceSamples.length,
    activePage: samplePageIndex,
    onPageClick: goToSample,
    compressed: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_transaction_action_menu.TransactionActionMenu, {
    isLoading: isLoading,
    transaction: entryTransaction
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_maybe_view_trace_link.MaybeViewTraceLink, {
    isLoading: isLoading,
    transaction: entryTransaction,
    waterfall: waterfallFetchResult.waterfall,
    environment: environment
  })))))), isLoading || !entryTransaction ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 1,
    "data-test-sub": "loading-content"
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_transaction_summary.TransactionSummary, {
    errorCount: waterfallFetchResult.waterfall.totalErrorsCount,
    totalDuration: (_waterfallFetchResult = waterfallFetchResult.waterfall.rootWaterfallTransaction) === null || _waterfallFetchResult === void 0 ? void 0 : _waterfallFetchResult.duration,
    transaction: entryTransaction
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_transaction_tabs.TransactionTabs, {
    transaction: entryTransaction,
    detailTab: detailTab,
    serviceName: serviceName,
    waterfallItemId: waterfallItemId,
    onTabClick: onTabClick,
    waterfall: waterfallFetchResult.waterfall,
    isLoading: isLoading,
    showCriticalPath: showCriticalPath,
    onShowCriticalPathChange: onShowCriticalPathChange
  })));
}