"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TraceExplorerAggregatedCriticalPath = TraceExplorerAggregatedCriticalPath;
var _react = _interopRequireWildcard(require("react"));
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_time_range = require("../../../hooks/use_time_range");
var _use_trace_explorer_samples = require("../../../hooks/use_trace_explorer_samples");
var _critical_path_flamegraph = require("../../shared/critical_path_flamegraph");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function TraceExplorerAggregatedCriticalPath() {
  const {
    query: {
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useApmParams)('/traces/explorer/critical_path');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    data: {
      traceSamples
    },
    status: samplesFetchStatus
  } = (0, _use_trace_explorer_samples.useTraceExplorerSamples)();
  const traceIds = (0, _react.useMemo)(() => {
    return traceSamples.map(sample => sample.traceId);
  }, [traceSamples]);
  return /*#__PURE__*/_react.default.createElement(_critical_path_flamegraph.CriticalPathFlamegraph, {
    start: start,
    end: end,
    traceIds: traceIds,
    traceIdsFetchStatus: samplesFetchStatus
  });
}