"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstructionsSet = InstructionsSet;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _instruction_variants = require("./instruction_variants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getTabs(variants) {
  return variants.map(variant => ({
    id: variant.id,
    text: (0, _instruction_variants.getDisplayText)(variant.id)
  }));
}
function InstructionsSet({
  instructions
}) {
  const tabs = getTabs(instructions.instructionVariants);
  const [selectedTab, setSelectedTab] = (0, _react.useState)(tabs[0].id);
  const onSelectedTabChange = tab => {
    setSelectedTab(tab);
  };
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  function InstructionTabs({
    agentTabs
  }) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
      style: {
        padding: `0 ${euiTheme.size.l}`
      }
    }, agentTabs.map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      key: tab.id,
      isSelected: tab.id === selectedTab,
      onClick: () => onSelectedTabChange(tab.id)
    }, tab.text)));
  }
  function InstructionSteps({
    instructionVariants,
    tab
  }) {
    const selectInstructionSteps = instructionVariants.find(variant => {
      return variant.id === tab;
    });
    if (!selectInstructionSteps) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
      titleSize: "xs",
      steps: selectInstructionSteps.instructions
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: "subdued",
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(InstructionTabs, {
    agentTabs: tabs
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, instructions.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(InstructionSteps, {
    instructionVariants: instructions.instructionVariants,
    tab: selectedTab
  })));
}