"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnvironmentField = EnvironmentField;
exports.ErrorGroupingKeyField = ErrorGroupingKeyField;
exports.IsAboveField = IsAboveField;
exports.ServiceField = ServiceField;
exports.TransactionNameField = TransactionNameField;
exports.TransactionTypeField = TransactionTypeField;
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _apm = require("../../../../common/es_fields/apm");
var _environment_filter_values = require("../../../../common/environment_filter_values");
var _suggestions_select = require("../../shared/suggestions_select");
var _popover_expression = require("../ui_components/popover_expression");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ServiceField({
  allowAll = true,
  currentValue,
  onChange
}) {
  return /*#__PURE__*/_react.default.createElement(_popover_expression.PopoverExpression, {
    value: currentValue || _environment_filter_values.allOptionText,
    title: _i18n.i18n.translate('xpack.apm.alerting.fields.service', {
      defaultMessage: 'Service'
    })
  }, /*#__PURE__*/_react.default.createElement(_suggestions_select.SuggestionsSelect, {
    customOptions: allowAll ? [{
      label: _environment_filter_values.allOptionText,
      value: undefined
    }] : undefined,
    customOptionText: _i18n.i18n.translate('xpack.apm.serviceNamesSelectCustomOptionText', {
      defaultMessage: 'Add \\{searchValue\\} as a new service name'
    }),
    defaultValue: currentValue,
    fieldName: _apm.SERVICE_NAME,
    onChange: onChange,
    placeholder: _i18n.i18n.translate('xpack.apm.serviceNamesSelectPlaceholder', {
      defaultMessage: 'Select service name'
    }),
    start: (0, _moment.default)().subtract(24, 'h').toISOString(),
    end: (0, _moment.default)().toISOString()
  }));
}
function EnvironmentField({
  currentValue,
  onChange,
  serviceName
}) {
  return /*#__PURE__*/_react.default.createElement(_popover_expression.PopoverExpression, {
    value: (0, _environment_filter_values.getEnvironmentLabel)(currentValue),
    title: _i18n.i18n.translate('xpack.apm.alerting.fields.environment', {
      defaultMessage: 'Environment'
    })
  }, /*#__PURE__*/_react.default.createElement(_suggestions_select.SuggestionsSelect, {
    customOptions: [_environment_filter_values.ENVIRONMENT_ALL],
    customOptionText: _i18n.i18n.translate('xpack.apm.environmentsSelectCustomOptionText', {
      defaultMessage: 'Add \\{searchValue\\} as a new environment'
    }),
    defaultValue: (0, _environment_filter_values.getEnvironmentLabel)(currentValue),
    fieldName: _apm.SERVICE_ENVIRONMENT,
    onChange: onChange,
    placeholder: _i18n.i18n.translate('xpack.apm.environmentsSelectPlaceholder', {
      defaultMessage: 'Select environment'
    }),
    start: (0, _moment.default)().subtract(24, 'h').toISOString(),
    end: (0, _moment.default)().toISOString(),
    serviceName: serviceName
  }));
}
function TransactionNameField({
  currentValue,
  onChange,
  serviceName
}) {
  const label = _i18n.i18n.translate('xpack.apm.alerting.fields.transaction.name', {
    defaultMessage: 'Name'
  });
  return /*#__PURE__*/_react.default.createElement(_popover_expression.PopoverExpression, {
    value: currentValue || _environment_filter_values.allOptionText,
    title: label
  }, /*#__PURE__*/_react.default.createElement(_suggestions_select.SuggestionsSelect, {
    customOptions: [{
      label: _environment_filter_values.allOptionText,
      value: undefined
    }],
    customOptionText: _i18n.i18n.translate('xpack.apm.alerting.transaction.name.custom.text', {
      defaultMessage: 'Add \\{searchValue\\} as a new transaction name'
    }),
    defaultValue: currentValue,
    fieldName: _apm.TRANSACTION_NAME,
    onChange: onChange,
    placeholder: _i18n.i18n.translate('xpack.apm.transactionNamesSelectPlaceholder', {
      defaultMessage: 'Select transaction name'
    }),
    start: (0, _moment.default)().subtract(24, 'h').toISOString(),
    end: (0, _moment.default)().toISOString(),
    serviceName: serviceName
  }));
}
function TransactionTypeField({
  currentValue,
  onChange,
  serviceName
}) {
  const label = _i18n.i18n.translate('xpack.apm.alerting.fields.type', {
    defaultMessage: 'Type'
  });
  return /*#__PURE__*/_react.default.createElement(_popover_expression.PopoverExpression, {
    value: currentValue || _environment_filter_values.allOptionText,
    title: label
  }, /*#__PURE__*/_react.default.createElement(_suggestions_select.SuggestionsSelect, {
    customOptions: [{
      label: _environment_filter_values.allOptionText,
      value: undefined
    }],
    customOptionText: _i18n.i18n.translate('xpack.apm.transactionTypesSelectCustomOptionText', {
      defaultMessage: 'Add \\{searchValue\\} as a new transaction type'
    }),
    defaultValue: currentValue,
    fieldName: _apm.TRANSACTION_TYPE,
    onChange: onChange,
    placeholder: _i18n.i18n.translate('xpack.apm.transactionTypesSelectPlaceholder', {
      defaultMessage: 'Select transaction type'
    }),
    start: (0, _moment.default)().subtract(24, 'h').toISOString(),
    end: (0, _moment.default)().toISOString(),
    serviceName: serviceName
  }));
}
function ErrorGroupingKeyField({
  currentValue,
  onChange,
  serviceName
}) {
  const label = _i18n.i18n.translate('xpack.apm.alerting.fields.error.group.id', {
    defaultMessage: 'Error grouping key'
  });
  return /*#__PURE__*/_react.default.createElement(_popover_expression.PopoverExpression, {
    value: currentValue || _environment_filter_values.allOptionText,
    title: label
  }, /*#__PURE__*/_react.default.createElement(_suggestions_select.SuggestionsSelect, {
    customOptions: [{
      label: _environment_filter_values.allOptionText,
      value: undefined
    }],
    customOptionText: _i18n.i18n.translate('xpack.apm.errorKeySelectCustomOptionText', {
      defaultMessage: 'Add \\{searchValue\\} as a new error grouping key'
    }),
    defaultValue: currentValue,
    fieldName: _apm.ERROR_GROUP_ID,
    onChange: onChange,
    placeholder: _i18n.i18n.translate('xpack.apm.errorGroupingKeySelectPlaceholder', {
      defaultMessage: 'Select error grouping key'
    }),
    start: (0, _moment.default)().subtract(24, 'h').toISOString(),
    end: (0, _moment.default)().toISOString(),
    serviceName: serviceName
  }));
}
function IsAboveField({
  value,
  unit,
  onChange,
  step
}) {
  return /*#__PURE__*/_react.default.createElement(_popover_expression.PopoverExpression, {
    value: `${value}${unit}`,
    title: _i18n.i18n.translate('xpack.apm.transactionErrorRateRuleType.isAbove', {
      defaultMessage: 'is above'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "data-test-subj": "apmIsAboveFieldFieldNumber",
    min: 0,
    value: value !== null && value !== void 0 ? value : 0,
    onChange: e => onChange(parseInt(e.target.value, 10)),
    append: unit,
    compressed: true,
    step: step
  }));
}