"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.schemaUnknownArray = exports.schemaUnknown = exports.schemaStringOrNumberArray = exports.schemaStringOrNumber = exports.schemaStringArray = exports.schemaString = exports.schemaNumberArray = exports.schemaNumber = exports.schemaGeoPointArray = exports.schemaGeoPoint = exports.schemaDateRangeArray = exports.schemaDateRange = exports.schemaDateArray = exports.schemaDate = exports.schemaBooleanArray = exports.schemaBoolean = exports.MlAnomalyDetectionHealthAlertSchema = exports.IsoDateString = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _alert_schema = require("./alert_schema");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// ---------------------------------- WARNING ----------------------------------
// this file was generated, and should not be edited by hand
// ---------------------------------- WARNING ----------------------------------

const ISO_DATE_PATTERN = /^d{4}-d{2}-d{2}Td{2}:d{2}:d{2}.d{3}Z$/;
const IsoDateString = exports.IsoDateString = new rt.Type('IsoDateString', rt.string.is, (input, context) => {
  if (typeof input === 'string' && ISO_DATE_PATTERN.test(input)) {
    return rt.success(input);
  } else {
    return rt.failure(input, context);
  }
}, rt.identity);
const schemaUnknown = exports.schemaUnknown = rt.unknown;
const schemaUnknownArray = exports.schemaUnknownArray = rt.array(rt.unknown);
const schemaString = exports.schemaString = rt.string;
const schemaStringArray = exports.schemaStringArray = rt.array(schemaString);
const schemaNumber = exports.schemaNumber = rt.number;
const schemaNumberArray = exports.schemaNumberArray = rt.array(schemaNumber);
const schemaDate = exports.schemaDate = rt.union([IsoDateString, schemaNumber]);
const schemaDateArray = exports.schemaDateArray = rt.array(schemaDate);
const schemaDateRange = exports.schemaDateRange = rt.partial({
  gte: schemaDate,
  lte: schemaDate
});
const schemaDateRangeArray = exports.schemaDateRangeArray = rt.array(schemaDateRange);
const schemaStringOrNumber = exports.schemaStringOrNumber = rt.union([schemaString, schemaNumber]);
const schemaStringOrNumberArray = exports.schemaStringOrNumberArray = rt.array(schemaStringOrNumber);
const schemaBoolean = exports.schemaBoolean = rt.boolean;
const schemaBooleanArray = exports.schemaBooleanArray = rt.array(schemaBoolean);
const schemaGeoPointCoords = rt.type({
  type: schemaString,
  coordinates: schemaNumberArray
});
const schemaGeoPointString = schemaString;
const schemaGeoPointLatLon = rt.type({
  lat: schemaNumber,
  lon: schemaNumber
});
const schemaGeoPointLocation = rt.type({
  location: schemaNumberArray
});
const schemaGeoPointLocationString = rt.type({
  location: schemaString
});
const schemaGeoPoint = exports.schemaGeoPoint = rt.union([schemaGeoPointCoords, schemaGeoPointString, schemaGeoPointLatLon, schemaGeoPointLocation, schemaGeoPointLocationString]);
const schemaGeoPointArray = exports.schemaGeoPointArray = rt.array(schemaGeoPoint);
// prettier-ignore
const MlAnomalyDetectionHealthAlertRequired = rt.type({});
// prettier-ignore
const MlAnomalyDetectionHealthAlertOptional = rt.partial({
  'kibana.alert.datafeed_results': rt.array(rt.partial({
    datafeed_id: schemaString,
    datafeed_state: schemaString,
    job_id: schemaString,
    job_state: schemaString
  })),
  'kibana.alert.delayed_data_results': rt.array(rt.partial({
    annotation: schemaString,
    end_timestamp: schemaDate,
    job_id: schemaString,
    missed_docs_count: schemaStringOrNumber
  })),
  'kibana.alert.job_errors_results': rt.array(rt.partial({
    errors: schemaUnknown,
    job_id: schemaString
  })),
  'kibana.alert.mml_results': rt.array(rt.partial({
    job_id: schemaString,
    log_time: schemaDate,
    memory_status: schemaString,
    model_bytes: schemaStringOrNumber,
    model_bytes_exceeded: schemaStringOrNumber,
    model_bytes_memory_limit: schemaStringOrNumber,
    peak_model_bytes: schemaStringOrNumber
  }))
});

// prettier-ignore
const MlAnomalyDetectionHealthAlertSchema = exports.MlAnomalyDetectionHealthAlertSchema = rt.intersection([MlAnomalyDetectionHealthAlertRequired, MlAnomalyDetectionHealthAlertOptional, _alert_schema.AlertSchema]);
// prettier-ignore