"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformActionParams = transformActionParams;
exports.transformSummaryActionParams = transformSummaryActionParams;
var _fp = require("lodash/fp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function transformActionParams({
  actionsPlugin,
  alertId,
  alertType,
  actionId,
  actionTypeId,
  alertName,
  spaceId,
  tags,
  alertInstanceId,
  alertUuid,
  alertActionGroup,
  alertActionGroupName,
  context,
  actionParams,
  state,
  kibanaBaseUrl,
  alertParams,
  ruleUrl,
  flapping,
  aadAlert,
  consecutiveMatches
}) {
  // when the list of variables we pass in here changes,
  // the UI will need to be updated as well; see:
  // x-pack/plugins/triggers_actions_ui/public/application/lib/action_variables.ts
  const variables = {
    alertId,
    alertName,
    spaceId,
    tags,
    alertInstanceId,
    alertActionGroup,
    alertActionGroupName,
    context,
    date: new Date().toISOString(),
    state,
    kibanaBaseUrl,
    params: alertParams,
    rule: {
      params: alertParams,
      id: alertId,
      name: alertName,
      type: alertType,
      spaceId,
      tags,
      url: ruleUrl
    },
    alert: {
      id: alertInstanceId,
      uuid: alertUuid,
      actionGroup: alertActionGroup,
      actionGroupName: alertActionGroupName,
      flapping,
      consecutiveMatches
    },
    ...(aadAlert ? {
      ...aadAlert
    } : {})
  };
  return actionsPlugin.renderActionParameterTemplates(actionTypeId, actionId, actionParams, variables);
}
function transformSummaryActionParams({
  alerts,
  rule,
  ruleTypeId,
  actionsPlugin,
  actionId,
  actionTypeId,
  spaceId,
  actionParams,
  ruleUrl,
  kibanaBaseUrl
}) {
  var _alerts$all$data, _alerts$all$count;
  const variables = {
    alertId: rule.id,
    alertName: rule.name,
    spaceId,
    tags: rule.tags,
    params: rule.params,
    alertInstanceId: rule.id,
    alertActionGroup: 'default',
    alertActionGroupName: 'Default',
    alert: {
      id: rule.id,
      uuid: rule.id,
      actionGroup: 'default',
      actionGroupName: 'Default',
      flapping: false,
      consecutiveMatches: 0
    },
    kibanaBaseUrl,
    date: new Date().toISOString(),
    // For backwards compatibility with security solutions rules
    context: {
      alerts: (_alerts$all$data = alerts.all.data) !== null && _alerts$all$data !== void 0 ? _alerts$all$data : [],
      results_link: ruleUrl,
      rule: (0, _fp.mapKeys)(_fp.snakeCase, {
        ...rule.params,
        name: rule.name,
        id: rule.id
      })
    },
    state: {
      signals_count: (_alerts$all$count = alerts.all.count) !== null && _alerts$all$count !== void 0 ? _alerts$all$count : 0
    },
    rule: {
      params: rule.params,
      id: rule.id,
      name: rule.name,
      type: ruleTypeId,
      url: ruleUrl,
      tags: rule.tags,
      spaceId
    },
    alerts
  };
  return actionsPlugin.renderActionParameterTemplates(actionTypeId, actionId, actionParams, variables);
}