"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runSoon = runSoon;
var _i18n = require("@kbn/i18n");
var _server = require("@kbn/task-manager-plugin/server");
var _authorization = require("../../authorization");
var _audit_events = require("../common/audit_events");
var _saved_objects = require("../../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function runSoon(context, {
  id
}) {
  var _context$auditLogger2;
  const {
    attributes
  } = await context.unsecuredSavedObjectsClient.get(_saved_objects.RULE_SAVED_OBJECT_TYPE, id);
  try {
    await context.authorization.ensureAuthorized({
      ruleTypeId: attributes.alertTypeId,
      consumer: attributes.consumer,
      operation: _authorization.WriteOperations.RunSoon,
      entity: _authorization.AlertingAuthorizationEntity.Rule
    });
    if (attributes.actions.length) {
      await context.actionsAuthorization.ensureAuthorized({
        operation: 'execute'
      });
    }
  } catch (error) {
    var _context$auditLogger;
    (_context$auditLogger = context.auditLogger) === null || _context$auditLogger === void 0 ? void 0 : _context$auditLogger.log((0, _audit_events.ruleAuditEvent)({
      action: _audit_events.RuleAuditAction.RUN_SOON,
      savedObject: {
        type: _saved_objects.RULE_SAVED_OBJECT_TYPE,
        id
      },
      error
    }));
    throw error;
  }
  (_context$auditLogger2 = context.auditLogger) === null || _context$auditLogger2 === void 0 ? void 0 : _context$auditLogger2.log((0, _audit_events.ruleAuditEvent)({
    action: _audit_events.RuleAuditAction.RUN_SOON,
    outcome: 'unknown',
    savedObject: {
      type: _saved_objects.RULE_SAVED_OBJECT_TYPE,
      id
    }
  }));
  context.ruleTypeRegistry.ensureRuleTypeEnabled(attributes.alertTypeId);

  // Check that the rule is enabled
  if (!attributes.enabled) {
    return _i18n.i18n.translate('xpack.alerting.rulesClient.runSoon.disabledRuleError', {
      defaultMessage: 'Error running rule: rule is disabled'
    });
  }
  let taskDoc = null;
  try {
    taskDoc = attributes.scheduledTaskId ? await context.taskManager.get(attributes.scheduledTaskId) : null;
  } catch (err) {
    return _i18n.i18n.translate('xpack.alerting.rulesClient.runSoon.getTaskError', {
      defaultMessage: 'Error running rule: {errMessage}',
      values: {
        errMessage: err.message
      }
    });
  }
  if (taskDoc && (taskDoc.status === _server.TaskStatus.Claiming || taskDoc.status === _server.TaskStatus.Running)) {
    return _i18n.i18n.translate('xpack.alerting.rulesClient.runSoon.ruleIsRunning', {
      defaultMessage: 'Rule is already running'
    });
  }
  try {
    await context.taskManager.runSoon(attributes.scheduledTaskId ? attributes.scheduledTaskId : id);
  } catch (err) {
    return _i18n.i18n.translate('xpack.alerting.rulesClient.runSoon.runSoonError', {
      defaultMessage: 'Error running rule: {errMessage}',
      values: {
        errMessage: err.message
      }
    });
  }
}