"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsSuggestionsSchema = void 0;
exports.registerAlertsValueSuggestionsRoute = registerAlertsValueSuggestionsRoute;
var _configSchema = require("@kbn/config-schema");
var _rxjs = require("rxjs");
var _server = require("@kbn/data-plugin/server");
var _terms_agg = require("@kbn/unified-search-plugin/server/autocomplete/terms_agg");
var _server2 = require("@kbn/kibana-utils-plugin/server");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _lib = require("../lib");
var _audit_events = require("../../rules_client/common/audit_events");
var _authorization = require("../../authorization");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const alertingAuthorizationFilterOpts = {
  type: _authorization.AlertingAuthorizationFilterType.ESDSL,
  fieldNames: {
    ruleTypeId: _ruleDataUtils.ALERT_RULE_TYPE_ID,
    consumer: _ruleDataUtils.ALERT_RULE_CONSUMER
  }
};
const AlertsSuggestionsSchema = exports.AlertsSuggestionsSchema = {
  body: _configSchema.schema.object({
    field: _configSchema.schema.string(),
    query: _configSchema.schema.string(),
    filters: _configSchema.schema.maybe(_configSchema.schema.any()),
    fieldMeta: _configSchema.schema.maybe(_configSchema.schema.any())
  })
};
const VALID_FEATURE_IDS = new Set([_ruleDataUtils.AlertConsumers.APM, _ruleDataUtils.AlertConsumers.INFRASTRUCTURE, _ruleDataUtils.AlertConsumers.LOGS, _ruleDataUtils.AlertConsumers.SLO, _ruleDataUtils.AlertConsumers.UPTIME]);
function registerAlertsValueSuggestionsRoute(router, licenseState, config$, getAlertIndicesAlias, usageCounter) {
  router.post({
    path: '/internal/alerts/suggestions/values',
    validate: AlertsSuggestionsSchema
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, request, response) {
    const config = await (0, _rxjs.firstValueFrom)(config$);
    const {
      field: fieldName,
      query,
      fieldMeta
    } = request.body;
    const abortSignal = (0, _server.getRequestAbortedSignal)(request.events.aborted$);
    const {
      savedObjects,
      elasticsearch
    } = await context.core;
    const rulesClient = (await context.alerting).getRulesClient();
    let authorizationTuple;
    let authorizedRuleType = [];
    try {
      const authorization = rulesClient.getAuthorization();
      authorizationTuple = await authorization.getFindAuthorizationFilter(_authorization.AlertingAuthorizationEntity.Alert, alertingAuthorizationFilterOpts);
      authorizedRuleType = await authorization.getAuthorizedRuleTypes(_authorization.AlertingAuthorizationEntity.Alert, VALID_FEATURE_IDS);
    } catch (error) {
      var _rulesClient$getAudit;
      (_rulesClient$getAudit = rulesClient.getAuditLogger()) === null || _rulesClient$getAudit === void 0 ? void 0 : _rulesClient$getAudit.log((0, _audit_events.ruleAuditEvent)({
        action: _audit_events.RuleAuditAction.FIND,
        error
      }));
      throw error;
    }
    const spaceId = rulesClient.getSpaceId();
    const {
      filter: authorizationFilter
    } = authorizationTuple;
    const filters = [...(authorizationFilter != null ? [authorizationFilter] : []), {
      term: {
        [_ruleDataUtils.SPACE_IDS]: spaceId
      }
    }];
    const index = getAlertIndicesAlias(authorizedRuleType.map(art => art.id), spaceId).join(',');
    try {
      const body = await (0, _terms_agg.termsAggSuggestions)(config, savedObjects.client, elasticsearch.client.asInternalUser, index, fieldName, query, filters, fieldMeta, abortSignal);
      return response.ok({
        body
      });
    } catch (e) {
      const kbnErr = (0, _server2.getKbnServerError)(e);
      return (0, _server2.reportServerError)(response, kbnErr);
    }
  })));
}