"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkDisableRulesRoute = void 0;
var _lib = require("../../../lib");
var _lib2 = require("../../../../lib");
var _types = require("../../../../types");
var _bulk_disable = require("../../../../../common/routes/rule/apis/bulk_disable");
var _transforms = require("../../transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bulkDisableRulesRoute = ({
  router,
  licenseState
}) => {
  router.patch({
    path: `${_types.INTERNAL_BASE_ALERTING_API_PATH}/rules/_bulk_disable`,
    validate: {
      body: _bulk_disable.bulkDisableRulesRequestBodySchemaV1
    }
  }, (0, _lib.handleDisabledApiKeysError)(router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async (context, req, res) => {
    const rulesClient = (await context.alerting).getRulesClient();
    const body = req.body;
    const {
      filter,
      ids,
      untrack
    } = body;
    try {
      const bulkDisableResults = await rulesClient.bulkDisableRules({
        filter,
        ids,
        untrack
      });
      const resultBody = {
        body: {
          ...bulkDisableResults,
          rules: bulkDisableResults.rules.map(rule => {
            // TODO (http-versioning): Remove this cast, this enables us to move forward
            // without fixing all of other solution types
            return (0, _transforms.transformRuleToRuleResponseV1)(rule);
          })
        }
      };
      return res.ok(resultBody);
    } catch (e) {
      if (e instanceof _lib2.RuleTypeDisabledError) {
        return e.sendResponse(res);
      }
      throw e;
    }
  }))));
};
exports.bulkDisableRulesRoute = bulkDisableRulesRoute;