"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stateSchemaByVersion = exports.emptyState = void 0;
var _configSchema = require("@kbn/config-schema");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * WARNING: Do not modify the existing versioned schema(s) below, instead define a new version (ex: 2, 3, 4).
 * This is required to support zero-downtime upgrades and rollbacks. See https://github.com/elastic/kibana/issues/155764.
 *
 * As you add a new schema version, don't forget to change latestTaskStateSchema variable to reference the latest schema.
 * For example, changing stateSchemaByVersion[1].schema to stateSchemaByVersion[2].schema.
 */
const stateSchemaByVersion = exports.stateSchemaByVersion = {
  1: {
    // A task that was created < 8.10 will go through this "up" migration
    // to ensure it matches the v1 schema.
    up: state => ({
      runs: state.runs || 0,
      // OK unless proven otherwise
      health_status: state.health_status || _types.HealthStatus.OK
    }),
    schema: _configSchema.schema.object({
      runs: _configSchema.schema.number(),
      health_status: _configSchema.schema.string()
    })
  }
};
const latestTaskStateSchema = stateSchemaByVersion[1].schema;
const emptyState = exports.emptyState = {
  runs: 0,
  // OK unless proven otherwise
  health_status: _types.HealthStatus.OK
};