"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkUntrackAlerts = bulkUntrackAlerts;
var _lodash = require("lodash");
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _apmUtils = require("@kbn/apm-utils");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _schemas = require("./schemas");
var _authorization = require("../../../../authorization");
var _retry_if_conflicts = require("../../../../lib/retry_if_conflicts");
var _audit_events = require("../../../../rules_client/common/audit_events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function bulkUntrackAlerts(context, params) {
  try {
    _schemas.bulkUntrackBodySchema.validate(params);
  } catch (error) {
    throw _boom.default.badRequest(`Failed to validate params: ${error.message}`);
  }
  return await (0, _retry_if_conflicts.retryIfConflicts)(context.logger, `rulesClient.bulkUntrack('${params.alertUuids}')`, async () => await bulkUntrackAlertsWithOCC(context, params));
}
async function bulkUntrackAlertsWithOCC(context, params) {
  try {
    var _context$auditLogger;
    if (!context.alertsService) throw new Error('unable to access alertsService');
    const result = await context.alertsService.setAlertsToUntracked({
      ...params,
      featureIds: params.featureIds || [],
      spaceId: context.spaceId,
      getAlertIndicesAlias: context.getAlertIndicesAlias,
      getAuthorizedRuleTypes: context.authorization.getAuthorizedRuleTypes.bind(context.authorization),
      ensureAuthorized: async ({
        ruleTypeId,
        consumer
      }) => await (0, _apmUtils.withSpan)({
        name: 'authorization.ensureAuthorized',
        type: 'alerts'
      }, () => context.authorization.ensureAuthorized({
        ruleTypeId,
        consumer,
        operation: _authorization.WriteOperations.Update,
        entity: _authorization.AlertingAuthorizationEntity.Alert
      }))
    });

    // Clear alert instances from their corresponding tasks so that they can remain untracked
    const taskIds = [...new Set(result.map(doc => doc[_ruleDataUtils.ALERT_RULE_UUID]))];
    await context.taskManager.bulkUpdateState(taskIds, (state, id) => {
      try {
        const uuidsToClear = result.filter(doc => doc[_ruleDataUtils.ALERT_RULE_UUID] === id).map(doc => doc[_ruleDataUtils.ALERT_UUID]);
        const alertTypeState = {
          ...state.alertTypeState,
          trackedAlerts: (0, _lodash.omitBy)(state.alertTypeState.trackedAlerts, ({
            alertUuid
          }) => uuidsToClear.includes(alertUuid))
        };
        const alertInstances = (0, _lodash.omitBy)(state.alertInstances, ({
          meta: {
            uuid
          }
        }) => uuidsToClear.includes(uuid));
        return {
          ...state,
          alertTypeState,
          alertInstances
        };
      } catch (e) {
        context.logger.error(`Failed to untrack alerts in task ID ${id}`);
        return state;
      }
    });
    (_context$auditLogger = context.auditLogger) === null || _context$auditLogger === void 0 ? void 0 : _context$auditLogger.log((0, _audit_events.ruleAuditEvent)({
      action: _audit_events.RuleAuditAction.UNTRACK_ALERT,
      outcome: 'success'
    }));
  } catch (error) {
    var _context$auditLogger2;
    (_context$auditLogger2 = context.auditLogger) === null || _context$auditLogger2 === void 0 ? void 0 : _context$auditLogger2.log((0, _audit_events.ruleAuditEvent)({
      action: _audit_events.RuleAuditAction.UNTRACK_ALERT,
      error
    }));
    throw error;
  }
}