"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformMaintenanceWindowToMaintenanceWindowAttributes = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformMaintenanceWindowToMaintenanceWindowAttributes = maintenanceWindow => {
  var _maintenanceWindow$sc, _maintenanceWindow$sc2, _maintenanceWindow$sc3, _maintenanceWindow$sc4, _maintenanceWindow$sc5, _maintenanceWindow$sc6;
  return {
    title: maintenanceWindow.title,
    enabled: maintenanceWindow.enabled,
    duration: maintenanceWindow.duration,
    expirationDate: maintenanceWindow.expirationDate,
    events: maintenanceWindow.events,
    rRule: maintenanceWindow.rRule,
    createdBy: maintenanceWindow.createdBy,
    updatedBy: maintenanceWindow.updatedBy,
    createdAt: maintenanceWindow.createdAt,
    updatedAt: maintenanceWindow.updatedAt,
    ...(maintenanceWindow.categoryIds !== undefined ? {
      categoryIds: maintenanceWindow.categoryIds
    } : {}),
    ...(maintenanceWindow.scopedQuery !== undefined ? (maintenanceWindow === null || maintenanceWindow === void 0 ? void 0 : maintenanceWindow.scopedQuery) == null ? {
      scopedQuery: maintenanceWindow === null || maintenanceWindow === void 0 ? void 0 : maintenanceWindow.scopedQuery
    } : {
      scopedQuery: {
        filters: (_maintenanceWindow$sc = maintenanceWindow === null || maintenanceWindow === void 0 ? void 0 : (_maintenanceWindow$sc2 = maintenanceWindow.scopedQuery) === null || _maintenanceWindow$sc2 === void 0 ? void 0 : _maintenanceWindow$sc2.filters) !== null && _maintenanceWindow$sc !== void 0 ? _maintenanceWindow$sc : [],
        kql: (_maintenanceWindow$sc3 = maintenanceWindow === null || maintenanceWindow === void 0 ? void 0 : (_maintenanceWindow$sc4 = maintenanceWindow.scopedQuery) === null || _maintenanceWindow$sc4 === void 0 ? void 0 : _maintenanceWindow$sc4.kql) !== null && _maintenanceWindow$sc3 !== void 0 ? _maintenanceWindow$sc3 : '',
        dsl: (_maintenanceWindow$sc5 = maintenanceWindow === null || maintenanceWindow === void 0 ? void 0 : (_maintenanceWindow$sc6 = maintenanceWindow.scopedQuery) === null || _maintenanceWindow$sc6 === void 0 ? void 0 : _maintenanceWindow$sc6.dsl) !== null && _maintenanceWindow$sc5 !== void 0 ? _maintenanceWindow$sc5 : ''
      }
    } : {})
  };
};
exports.transformMaintenanceWindowToMaintenanceWindowAttributes = transformMaintenanceWindowToMaintenanceWindowAttributes;