"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSelectedForDatePicker = getSelectedForDatePicker;
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
require("moment-timezone");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getSelectedForDatePicker(form, path, timezone) {
  // parse from a string date to moment() if there is an intitial value
  // otherwise just get the current date
  const initialValue = (0, _lodash.get)(form, path);
  let selected = (0, _moment.default)();
  if (initialValue && (0, _moment.default)(initialValue).isValid()) {
    selected = (0, _moment.default)(initialValue);
  }
  const utcOffset = timezone && timezone.length > 0 ? (0, _moment.default)().tz(timezone[0]).year(selected.year()).month(selected.month()).date(selected.date()).hour(selected.hour()).minute(selected.minute()).second(selected.second()).millisecond(selected.millisecond()).utcOffset() : selected.utcOffset();
  return {
    selected: selected.clone().utcOffset(utcOffset),
    utcOffset
  };
}