"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyPrompt = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const emptyTitle = /*#__PURE__*/_react.default.createElement("h2", null, i18n.EMPTY_PROMPT_TITLE);
const emptyBody = /*#__PURE__*/_react.default.createElement("p", null, i18n.EMPTY_PROMPT_DESCRIPTION);
const EmptyPrompt = exports.EmptyPrompt = /*#__PURE__*/_react.default.memo(({
  onClickCreate,
  showCreateButton = true,
  docLinks
}) => {
  const renderActions = (0, _react.useMemo)(() => {
    if (showCreateButton) {
      return [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        key: "create-action",
        fill: true,
        onClick: onClickCreate
      }, i18n.EMPTY_PROMPT_BUTTON), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        key: "documentation-button",
        target: "_blank",
        href: docLinks.alerting.maintenanceWindows,
        iconType: "help"
      }, i18n.EMPTY_PROMPT_DOCUMENTATION)];
    }
    return null;
  }, [showCreateButton, onClickCreate, docLinks]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
    "data-test-subj": "mw-empty-prompt",
    title: emptyTitle,
    body: emptyBody,
    actions: renderActions
  });
});
EmptyPrompt.displayName = 'EmptyPrompt';