"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleLastRunOutcomeValues = exports.RuleLastRunOutcomeOrderMap = exports.RuleExecutionStatusWarningReasons = exports.RuleExecutionStatusValues = exports.RuleExecutionStatusErrorReasons = exports.HealthStatus = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// rule type defined alert fields to persist in alerts index

// for the `typeof ThingValues[number]` types below, become string types that
// only accept the values in the associated string arrays
const RuleExecutionStatusValues = exports.RuleExecutionStatusValues = ['ok', 'active', 'error', 'pending', 'unknown', 'warning'];
const RuleLastRunOutcomeValues = exports.RuleLastRunOutcomeValues = ['succeeded', 'warning', 'failed'];
const RuleLastRunOutcomeOrderMap = exports.RuleLastRunOutcomeOrderMap = {
  succeeded: 0,
  warning: 10,
  failed: 20
};
let RuleExecutionStatusErrorReasons = exports.RuleExecutionStatusErrorReasons = /*#__PURE__*/function (RuleExecutionStatusErrorReasons) {
  RuleExecutionStatusErrorReasons["Read"] = "read";
  RuleExecutionStatusErrorReasons["Decrypt"] = "decrypt";
  RuleExecutionStatusErrorReasons["Execute"] = "execute";
  RuleExecutionStatusErrorReasons["Unknown"] = "unknown";
  RuleExecutionStatusErrorReasons["License"] = "license";
  RuleExecutionStatusErrorReasons["Timeout"] = "timeout";
  RuleExecutionStatusErrorReasons["Disabled"] = "disabled";
  RuleExecutionStatusErrorReasons["Validate"] = "validate";
  return RuleExecutionStatusErrorReasons;
}({});
let RuleExecutionStatusWarningReasons = exports.RuleExecutionStatusWarningReasons = /*#__PURE__*/function (RuleExecutionStatusWarningReasons) {
  RuleExecutionStatusWarningReasons["MAX_EXECUTABLE_ACTIONS"] = "maxExecutableActions";
  RuleExecutionStatusWarningReasons["MAX_ALERTS"] = "maxAlerts";
  RuleExecutionStatusWarningReasons["MAX_QUEUED_ACTIONS"] = "maxQueuedActions";
  return RuleExecutionStatusWarningReasons;
}({});
let HealthStatus = exports.HealthStatus = /*#__PURE__*/function (HealthStatus) {
  HealthStatus["OK"] = "ok";
  HealthStatus["Warning"] = "warn";
  HealthStatus["Error"] = "error";
  return HealthStatus;
}({});