"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.overridesHandlerFactory = void 0;
var _actions = require("@kbn/aiops-log-rate-analysis/api/actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const overridesHandlerFactory = ({
  requestBody,
  logDebugMessage,
  responseStream,
  stateHandler
}) => () => {
  var _requestBody$override, _requestBody$override2;
  if (!requestBody.overrides) {
    logDebugMessage('Full Reset.');
    responseStream.push((0, _actions.resetAllAction)());
  } else {
    logDebugMessage('Reset Errors.');
    responseStream.push((0, _actions.resetErrorsAction)());
  }
  if ((_requestBody$override = requestBody.overrides) !== null && _requestBody$override !== void 0 && _requestBody$override.regroupOnly) {
    logDebugMessage('Reset Groups.');
    responseStream.push((0, _actions.resetGroupsAction)());
  }
  if ((_requestBody$override2 = requestBody.overrides) !== null && _requestBody$override2 !== void 0 && _requestBody$override2.loaded) {
    var _requestBody$override3, _requestBody$override4;
    logDebugMessage(`Set 'loaded' override to '${(_requestBody$override3 = requestBody.overrides) === null || _requestBody$override3 === void 0 ? void 0 : _requestBody$override3.loaded}'.`);
    stateHandler.loaded((_requestBody$override4 = requestBody.overrides) === null || _requestBody$override4 === void 0 ? void 0 : _requestBody$override4.loaded);
  }
};
exports.overridesHandlerFactory = overridesHandlerFactory;