"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OPEN_CHANGE_POINT_IN_ML_APP_ACTION = void 0;
exports.createOpenChangePointInMlAppAction = createOpenChangePointInMlAppAction;
var _i18n = require("@kbn/i18n");
var _constants = require("@kbn/aiops-change-point-detection/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OPEN_CHANGE_POINT_IN_ML_APP_ACTION = exports.OPEN_CHANGE_POINT_IN_ML_APP_ACTION = 'openChangePointInMlAppAction';
function createOpenChangePointInMlAppAction(coreStart, pluginStart) {
  return {
    id: 'open-change-point-in-ml-app',
    type: OPEN_CHANGE_POINT_IN_ML_APP_ACTION,
    getIconType(context) {
      return 'link';
    },
    getDisplayName: () => _i18n.i18n.translate('xpack.aiops.actions.openChangePointInMlAppName', {
      defaultMessage: 'Open in AIOps Labs'
    }),
    async getHref(context) {
      const locator = pluginStart.share.url.locators.get('ML_APP_LOCATOR');
      const {
        timeRange,
        metricField,
        fn,
        splitField,
        dataViewId
      } = context.embeddable.getInput();
      return locator.getUrl({
        page: 'aiops/change_point_detection',
        pageState: {
          index: dataViewId,
          timeRange,
          fieldConfigs: [{
            fn,
            metricField,
            ...(splitField ? {
              splitField
            } : {})
          }]
        }
      });
    },
    async execute(context) {
      if (!context.embeddable) {
        throw new Error('Not possible to execute an action without the embeddable context');
      }
      const aiopsChangePointUrl = await this.getHref(context);
      if (aiopsChangePointUrl) {
        await coreStart.application.navigateToUrl(aiopsChangePointUrl);
      }
    },
    async isCompatible({
      embeddable
    }) {
      return embeddable.type === _constants.EMBEDDABLE_CHANGE_POINT_CHART_TYPE;
    }
  };
}