"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EDIT_CHANGE_POINT_CHARTS_ACTION = void 0;
exports.createEditChangePointChartsPanelAction = createEditChangePointChartsPanelAction;
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/embeddable-plugin/common");
var _constants = require("@kbn/aiops-change-point-detection/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EDIT_CHANGE_POINT_CHARTS_ACTION = exports.EDIT_CHANGE_POINT_CHARTS_ACTION = 'editChangePointChartsPanelAction';
function createEditChangePointChartsPanelAction(coreStart, pluginStart) {
  return {
    id: 'edit-change-point-charts',
    type: EDIT_CHANGE_POINT_CHARTS_ACTION,
    getIconType(context) {
      return 'pencil';
    },
    getDisplayName: () => _i18n.i18n.translate('xpack.aiops.actions.editChangePointChartsName', {
      defaultMessage: 'Edit change point charts'
    }),
    async execute({
      embeddable
    }) {
      if (!embeddable) {
        throw new Error('Not possible to execute an action without the embeddable context');
      }
      try {
        const {
          resolveEmbeddableChangePointUserInput
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('../embeddable/handle_explicit_input')));
        const result = await resolveEmbeddableChangePointUserInput(coreStart, pluginStart, embeddable.getInput());
        embeddable.updateInput(result);
      } catch (e) {
        return Promise.reject();
      }
    },
    async isCompatible({
      embeddable
    }) {
      return embeddable.type === _constants.EMBEDDABLE_CHANGE_POINT_CHART_TYPE && embeddable.getInput().viewMode === _common.ViewMode.EDIT;
    }
  };
}