"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AiopsPlugin = void 0;
var _rxjs = require("rxjs");
var _constants = require("@kbn/aiops-change-point-detection/constants");
var _embeddable_change_point_chart_component = require("./embeddable/embeddable_change_point_chart_component");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class AiopsPlugin {
  setup(core, {
    embeddable,
    cases,
    licensing,
    uiActions
  }) {
    Promise.all([(0, _rxjs.firstValueFrom)(licensing.license$), Promise.resolve().then(() => _interopRequireWildcard(require('./embeddable/register_embeddable'))), Promise.resolve().then(() => _interopRequireWildcard(require('./ui_actions'))), Promise.resolve().then(() => _interopRequireWildcard(require('./cases/register_change_point_charts_attachment'))), core.getStartServices()]).then(([license, {
      registerEmbeddable
    }, {
      registerAiopsUiActions
    }, {
      registerChangePointChartsAttachment
    }, [coreStart, pluginStart]]) => {
      if (license.hasAtLeast('platinum')) {
        if (embeddable) {
          registerEmbeddable(core, embeddable);
        }
        if (uiActions) {
          registerAiopsUiActions(uiActions, coreStart, pluginStart);
        }
        if (cases) {
          registerChangePointChartsAttachment(cases, coreStart, pluginStart);
        }
      }
    });
  }
  start(core, plugins) {
    return {
      EmbeddableChangePointChart: (0, _embeddable_change_point_chart_component.getEmbeddableChangePointChart)(_constants.EMBEDDABLE_CHANGE_POINT_CHART_TYPE, core, plugins)
    };
  }
  stop() {}
}
exports.AiopsPlugin = AiopsPlugin;